package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 查询金蝶云仓库基础信息
 */
@Component
public class BsStoreKingdeeApi {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "BD_STOCK";//仓库基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public BsStoreKingdeeApi() {
        /*查询字段*/
        key.put("FStockId", "FStockId");//单据头实体主键
        key.put("FNumber", "FNumber");//编码
        key.put("FName", "FName");//名称
        key.put("FCreateOrgId.Fnumber", "FCreateOrgId.Fnumber");//创建组织编码
        key.put("FStockStatusType", "FStockStatusType");//仓库类型
        key.put("FStockProperty", "FStockProperty");//仓库属性
        key.put("FCreateDate", "FCreateDate");//创建时间
    }

    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(sFormId, key, map, "仓库基础信息");
        return PojoToIMS(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 4, salesordermap, fieldList);

                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("storeCode", list1.get(1).toString());
                    salesordermap.put("storeName", list1.get(2).toString());
                    salesordermap.put("orgId", list1.get(3).toString());
                    salesordermap.put("storeType", list1.get(4).toString());
                    salesordermap.put("pptType", list1.get(5).toString());
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> error = new HashMap<>();
                error.put("false", message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }


}
