package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.demo.mock.MockController;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
/**
 * 查询委外订单信息
 */
@Component
@Slf4j
public class BsWplanOutsKingdeeApi {
    /**操作的单据体名称*/
    private String sFormId = "SUB_SUBREQORDER";//委外订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public BsWplanOutsKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FSubOrgId.Fnumber","FSubOrgId.Fnumber");//生产组织
        key.put("FBillNo","FBillNo");//编码
        key.put("FMaterialId.Fnumber","FMaterialId.Fnumber");//物料编码
        key.put("FQty","FQty");//数量
        key.put("FPlanStartDate","FPlanStartDate");//计划开工时间
        key.put("FPlanFinishDate","FPlanFinishDate");//计划完工时间
        key.put("FSaleOrderId","FSaleOrderId");//销售订单ID
        key.put("FFinishDate","FFinishDate");//完工日期
        key.put("FDescription","FDescription");//备注
        key.put("FParentRowId","FParentRowId");//父级行主键
        key.put("FTreeEntity_Fseq","FTreeEntity_Fseq");//行号
        key.put("FTreeEntity_FEntryId","FTreeEntity_FEntryId");//行内码
        key.put("FBomId.Fnumber", "FBomId.Fnumber");//bom版本
        key.put("FSupplierId.FNumber", "FSupplierId.FNumber");//bom版本
    }
    /**
     * 查询销售订单中的客户编码
     * @param id
     * @return
     */
    public List<List<Object>> getCustid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SAL_SaleOrder", new HashMap<String, String>() {{
            //根据单据编码查询客户ID
            put("FCustId.FNumber", "FCustId.FNumber");
            put("FID","FID");
        }}, new HashMap<String, String>() {{
            put("FID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"".equals(lists.get(0).get(0))){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }
    /**
     * 查询父级的子项物料编码
     * @param id
     * @return
     */
    public List<List<Object>> getMaterid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SUB_PPBOM", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMaterialID2.Fnumber", "FMaterialID2.Fnumber");
            put("FROWID", "FROWID");
        }}, new HashMap<String, String>() {{
            put("FROWID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if(lists.isEmpty()||("").equals(lists.get(0).get(0).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }
    

    /**
     * 查询委外用料清单
     * @param id
     * @return
     */
    public List<List<Object>> getwplanMn(String id, String seq) {
        List<List<Object>> lists = categoryDao.selectAndLog("SUB_PPBOM", new LinkedHashMap<String, String>() {{
            put("FNumerator", "FNumerator");
            put("FDenominator", "FDenominator");
            put("FStdQty", "FStdQty");
            put("FNeedQty2", "FNeedQty2");
            put("FEntity_FEntryID", "FEntity_FEntryID");
            put("FEntity_Fseq", "FEntity_Fseq");
            put("FParentRowId", "FParentRowId");
            put("FMaterialID2.Fnumber", "FMaterialID2.Fnumber");
            put("FPositionNO", "FPositionNO");
        }}, new HashMap<String, String>() {{
            put("FSubReqBillNO", id);
            put("FSubReqEntrySeq", seq);
        }}, "委外用料清单查询");
        if (CollectionUtils.isEmpty(lists)) {
            return new ArrayList<>();
        }
        return lists;
    }
    
    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) throws ParseException {
        ImsSynConstants.purchaseKingDee(this.key, fieldList);
        
        List<List<Object>> list = categoryDao.select(sFormId, key,map,"主计划信息");
        return PojoToIMS(list, fieldList);
    }
    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> custMap = new HashMap<>();
                String cust = "";

                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 15, salesordermap, fieldList);

                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    String fseq = "";
                    if (list1.get(11).toString().length() == 1) {
                        fseq = "00" + list1.get(11);
                    } else if (list1.get(11).toString().length() == 2) {
                        fseq = "0" + list1.get(11);
                    } else {
                        fseq = String.valueOf(list1.get(11));
                    }
                    salesordermap.put("wplanCode", list1.get(2) + "_" + fseq);
                    salesordermap.put("erpMo", list1.get(2).toString());
                    salesordermap.put("prodCode", list1.get(3).toString());
                    salesordermap.put("pqty", list1.get(4).toString());
                    salesordermap.put("bomVer", list1.get(13).toString());
                    salesordermap.put("supCode", list1.get(14).toString());
                    salesordermap.put("erpSeq", list1.get(11).toString());
                    Date parse = null;
                    Date parse1 = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(5).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pbdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("pbDate", pbdate);
                    try {
                        parse1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(6).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pedate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("peDate", pedate);
                    if (null == list1.get(7)) {
                        salesordermap.put("custCode", "");
                    } else {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //物料编码
                        idList.add(list1.get(7).toString());
                        //主键ID
                        custMap.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        cust = "'" + list1.get(7).toString() + "'," + cust;
                        salesordermap.put("FSaleOrderId", list1.get(7).toString());
                    }
                    if (null == list1.get(8) || " ".equals(list1.get(8).toString())) {
                        salesordermap.put("ptCode", "");
                    } else {
                        salesordermap.put("ptCode", list1.get(8).toString());
                    }
                    salesordermap.put("deliveryDate", "");

                    salesorderlist.add(salesordermap);
                }

                if (!"".equals(cust)) {
                    //批量查出所有生产用料清单的数据
                    cust = cust.substring(0, cust.length() - 1);
                    List<List<Object>> custid = getCustid(cust);
                    if (null == custid || "".equals(custid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("custCode", "");
                        }
                    } else {
                        //将集合赋值
                        for (String fid : custMap.keySet()) {
                            for (List custlist : custid) {
                                //如果对应的行内码相同
                                if (custMap.get(fid).get(0).equals(custlist.get(0).toString())) {
                                    //将信息添加到集合
                                    custMap.get(fid).add(custlist.get(1).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : custMap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FTreeEntity_FEntryId")) && custMap.get(fid).get(0).equals(salesordermap.get("FSaleOrderId"))) {
                                    //如果对应的编码不为空
                                    if (null != custMap.get(fid).get(1)) {
                                        salesordermap.put("custCode", custMap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("custCode", "");
                                    }
                                }
                            }
                        }
                    }
                }

                for (Map<String, String> map : salesorderlist) {
                    List<List<Object>> result = getwplanMn(map.get("erpMo"), map.get("erpSeq"));
                    String id = result.stream()
                            .filter(m -> StringUtils.isNotBlank((String) m.get(6)))
                            .map(m -> "'" + m.get(6) + "'")
                            .collect(Collectors.joining(","));
                    List<List<Object>> materList = getMaterid(id);

                    for (List<Object> objects : result) {
                        if (StringUtils.isNotBlank((String) objects.get(6))) {
                            Object o = materList.stream().filter(m -> m.get(1).equals(objects.get(6))).map(m -> m.get(0)).findFirst().orElse("");
                            objects.add(o);
                        } else {
                            objects.add("");
                        }
                    }
                    map.put(map.get("erpSeq"), JsonUtil.toString(result));
                }

            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> error = new HashMap<>();
                error.put("false", message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }
    


    public String update(Object object) {
        return null;
    }
}
