package org.jeecg.modules.iost.ims.kingdeeapi;

import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class DeductionFormKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;

    private static final String FORM_ID = "AP_Payable";

    private static final String KING_DEE_LOG_NAME = "扣款单";


    public String addTwo(List<Map<String, Object>> lists) {
        Map<String, Object> stringStringMap = imsToKingDee(lists);
        return categoryDao.addReturnResult(KING_DEE_LOG_NAME, FORM_ID, JsonUtil.Mapjson(stringStringMap));
    }

    public Map<String, Object> imsToKingDee(List<Map<String, Object>> list) {
        /* 单据头 */
        Map<String, Object> modelMap = new HashMap<>();
        /* 明细 */
        List<Map<String, Object>> entryList = new ArrayList<>();
        for (Map<String, Object> map : list) {
            //转换成金蝶云格式
            //单据类型
            modelMap.put("FBillTypeID", new HashMap<String, Object>() {{
                put("FNumber", "YFD02_SYS");
            }});
            //单据编码
            modelMap.put("FBillNo", map.get("SUP_DEDUCTIONS_CODE"));
            //业务类型
            modelMap.put("FBUSINESSTYPE", "FY");
            //立账类型
            modelMap.put("FSetAccountType", "3");
            String remark = "";
            if (StringUtils.isNotBlank(String.valueOf(map.get("DEDUCTIONS_REASON")))) {
                remark = "扣款原因: " + map.get("DEDUCTIONS_REASON");
            }
            if (StringUtils.isNotBlank(String.valueOf(map.get("APPEAL_REASON")))) {
                if (StringUtils.isNotBlank(remark)) {
                    remark = remark + " 申诉原因: " + map.get("APPEAL_REASON");
                } else {
                    remark = "申诉原因: " + map.get("APPEAL_REASON");
                }
            }
            if (StringUtils.isNotBlank(String.valueOf(map.get("REMARK")))) {
                if (StringUtils.isNotBlank(remark)) {
                    remark = remark + " " + map.get("REMARK");
                } else {
                    remark = String.valueOf(map.get("REMARK"));
                }
            }
            //备注
            modelMap.put("FAP_Remark", remark);
            //日期
            modelMap.put("FDATE", map.get("REVIEW_DATE"));
            //供应商编码
            modelMap.put("FSUPPLIERID", new HashMap<String, Object>() {{
                put("FNumber", map.get("SUP_CODE"));
            }});

            Map<String, Object> fEntityMap = new HashMap<>();
            //扣款类型
            fEntityMap.put("FCOSTID", new HashMap<String, Object>() {{
                put("FNumber", "fy52");
            }});
            //计价数量
            if (map.containsKey("DEDUCTIONS_TYPE") && "6".equals(String.valueOf(map.get("DEDUCTIONS_TYPE")))) {
                fEntityMap.put("FPriceQty", "1");
            } else {
                fEntityMap.put("FPriceQty", "-1");
            }
            //实际扣款金额
            fEntityMap.put("FTaxPrice", map.get("ACTUAL_DEMONEY"));
            //税率
            fEntityMap.put("FEntryTaxRate", map.get("TAX_RATE"));
            //税额
            fEntityMap.put("FTAXAMOUNTFOR_D", map.get("TAX"));
            //未税金额
            fEntityMap.put("FNoTaxAmountFor_D", map.get("TMEXTAX"));
            entryList.add(fEntityMap);
        }

        modelMap.put("FEntityDetail", entryList);
        return modelMap;

    }


}
