package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;


public class HttpUtil {

    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    /**
     * 连接超时时间
     */
    private static final int CONN_TIMEOUT = 12000;

    /**
     * 请求超时时间
     */
    private static final int READ_TIMEOUT = 12000;

    /**
     * 请求工具
     */
    private static RestTemplate restTemplate;


    static {
        //设置超时时间
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(CONN_TIMEOUT);
        requestFactory.setReadTimeout(READ_TIMEOUT);
        restTemplate = new RestTemplate(requestFactory);
    }

    /**
     * 设置header公共参数
     */
    private static HttpHeaders initHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Accpet-Encoding", "gzip");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/json; charset=UTF-8");
        return headers;
    }

    /**
     * * 判断一个对象是否为空
     *
     * @param object Object
     * @return true：为空 false：非空
     */
    public static boolean isNull(Object object) {
        return object == null;
    }
    
    public static boolean isNotNull(Object object) {
        return !isNull(object);
    }
    /**
     * 设置header参数
     */
    private static void setHeaderParam(HttpHeaders httpHeaders, Map<String, Object> headers) {
        if (!CollectionUtils.isEmpty(headers)) {
            Set<String> keys = headers.keySet();
            for (String key : keys) {
            	if(isNotNull(headers.get(key)))
            	{
                    httpHeaders.add(key, headers.get(key).toString());
            	}
            }
        }
    }

    /**
     * 发送Get请求
     */
    public static ResponseEntity<String> httpGet(String url) {
        //初始化header公共参数
        HttpHeaders httpHeaders = initHeader();
        //发送请求
        HttpEntity<String> httpEntity = new HttpEntity<>(null, httpHeaders);        

        ResponseEntity<String> result = null;
        
        try {
        	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        }
        catch(Exception ex)
        {
            try {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
            catch(Exception e)
            {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
        }
        
        return result;
    }

    /**
     * 发送Get请求
     */
    public static ResponseEntity<String> httpGet(String url, Map<String, Object> param) {
        //初始化header公共参数
        HttpHeaders httpHeaders = initHeader();
        //组装查询参数
        url = setParam(url, param);
        //发送请求
        HttpEntity<String> httpEntity = new HttpEntity<>(null, httpHeaders);        
        ResponseEntity<String> result = null;
        
        try {
        	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        }
        catch(Exception ex)
        {
            try {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
            catch(Exception e)
            {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
        }
        
        return result;
    }

    private static String setParam(String url, Map<String, Object> param) {
        Set<String> keys = param.keySet();
        StringBuilder builder = new StringBuilder();
        builder.append("?");
        for (String key : keys) {
            builder.append(key).append("=").append(param.get(key)).append("&");
        }
        builder.deleteCharAt(builder.lastIndexOf("&"));
        url = url + builder.toString();
        return url;
    }

    /**
     * 发送Get请求
     */
    public static ResponseEntity<String> httpGet(String url, Map<String, Object> headers, Map<String, Object> param) {
        //如果查询参数为空，则调用不带参数的Get请求
        if (CollectionUtils.isEmpty(param)) {
            return httpGet(url, headers);
        }
        //组装查询参数
        url = setParam(url, param);
        //发送请求
        return httpGet(url, headers);
    }

    /**
     * 发送Post请求
     */
    public static ResponseEntity<String> httpPost(String url, String json) {
        //初始化header公共参数
        HttpHeaders httpHeaders = initHeader();
        //发送请求
        return toPost(url, httpHeaders, json);
    }

    /**
     * 发送Post请求
     */
    public static ResponseEntity<String> httpPost(String url, Map<String, Object> header, String json) {
        //初始化header公共参数
        HttpHeaders httpHeaders = initHeader();
        setHeaderParam(httpHeaders, header);
        //发送请求
        return toPost(url, httpHeaders, json);
    }
    

    public static String login(String serverUrl) {
        try {
            Map<String, Object> request = new HashMap<>(1);
            request.put("parameters", new Object[]{"6476c5b6077e71", "Administrator", "sa123.sa", 2052});

            String url = serverUrl + "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";
            
            String requestStr = JsonUtil.toString(request);
            ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, requestStr);
            log.info("login", responseEntity.getBody());

            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                Map<String, Object> map = JsonUtil.toMap(responseEntity.getBody(), String.class, Object.class);
                if (!CollectionUtils.isEmpty(map) && 1 == Integer.parseInt(String.valueOf(map.get("LoginResultType")))) {
                    return getCookieStore(responseEntity);
                } else {
                    return "";
                }
            } else {
                return "";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getCookieStore(ResponseEntity<String> responseEntity) {
        String cookieStore = "";
        Set<String> keys = responseEntity.getHeaders().keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("Set-Cookie")) {
                List<String> cookieList = responseEntity.getHeaders().get(key);
                if (!CollectionUtils.isEmpty(cookieList)) {
                    for (String cookie : cookieList) {
                        if (cookie.startsWith("kdservice-sessionid")) {
                            cookieStore = cookie;
                            break;
                        }
                    }
                }
            }
        }
        return cookieStore;
    }
    /**
     * 发送请求
     */
    private static ResponseEntity<String> toPost(String url, HttpHeaders httpHeaders, String json) {
        HttpEntity<String> httpEntity = new HttpEntity<>(json, httpHeaders);
        ResponseEntity<String> result = null;
        
        try {
        	
        	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
        }
        catch(Exception ex)
        {
            try {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
            catch(Exception e)
            {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class);
            }
        }
        
        return result;
    }

    /**
     * 文件二进制
     */
    public static byte[] download(String url, String json) {
        //初始化header公共参数
        HttpHeaders httpHeaders = initHeader();
        HttpEntity<String> httpEntity = new HttpEntity<>(json, httpHeaders);

        ResponseEntity<byte[]> result = null;
        try {
        	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class);
        }
        catch(Exception ex)
        {
            try {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class);
            }
            catch(Exception e)
            {
            	result = restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class);
            }
        }
        
        
        return result.getBody();
    }


}