package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class ImmediateInventoryKingdeeApi {

    private static final String S_FORM_ID = "STK_Inventory";

    private Map<String, String> key = new LinkedHashMap<>();

    @Autowired
    private CategoryDao categoryDao;


    public ImmediateInventoryKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 库存组织 */
        key.put("FStockOrgId.FNumber", "FStockOrgId.FNumber");
        /* 物料编码 */
        key.put("FMaterialId.FNumber", "FMaterialId.FNumber");
        /* 物料名称 */
        key.put("FMaterialName", "FMaterialName");
        /* 库存量(基本单位) */
        key.put("FBaseQty", "FBaseQty");
        /* 可用量（主单位） */
        key.put("FAVBQty", "FAVBQty");
        /* 仓库编码 */
        key.put("FStockId.Fnumber", "FStockId.Fnumber");
    }

    public List<Map<String, Object>> selectAndLog(Map<String, String> map, String kingDeeLogName) {
        List<List<Object>> list = categoryDao.select(S_FORM_ID, key, map, kingDeeLogName);
        return pojoToIms(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, Object>> pojoToIms(List<List<Object>> list) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> objectList : list) {
                    Map<String, Object> map = new HashMap<>(5);

                    map.put("org_id", objectList.get(1));
                    map.put("mtrl_code", objectList.get(2));
                    map.put("mtrl_name", objectList.get(3));
                    map.put("qty", objectList.get(4));
                    map.put("f_qty", objectList.get(5));
                    map.put("stock_code", objectList.get(6));
                    result.add(map);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, Object> temp = new HashMap<>(2);
                temp.put("false", message);
                result.add(temp);
            }
        }
        return result;
    }


}
