package org.jeecg.modules.iost.ims.kingdeeapi;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class ImsCommonPushKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;


    /**
     * 根据FID查询子单据关联表源单分录内码
     */
    public List<List<Object>> selectLinkFsId(String fId, String sFormId, String linkFsIdName, String kingDeeLogName) {
        List<List<Object>> list = categoryDao.select(sFormId, new HashMap<String, String>(1) {{
            put(linkFsIdName, linkFsIdName);
        }}, new HashMap<String, String>(1) {{
            put("FID", fId);
        }}, kingDeeLogName + "源分录内码查询");
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    /**
     * 查询子单据行内码
     */
    public String getEntryId(String sFormId, String fid, String entryIdName, String linkFsId, String linkFsIdName, String kingDeeLogName) {
        return categoryDao.getSonEntryIdSpecial(sFormId, fid, entryIdName, linkFsId, linkFsIdName, kingDeeLogName + "子单据行内码查询");
    }

    /**
     * 父单据下推到子单据
     */
    public String push(String kingDeeLogPushName, String fathersFormId, List<String> fatherEntryIdList, String pushRule, String sFormId) {
        //下推父单据的FormId-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-EntryID
        return categoryDao.pushMore(kingDeeLogPushName, fathersFormId, fatherEntryIdList, pushRule, sFormId);
    }

    /**
     * 查询needLists所有数据的父单据的FEntryID
     */
    public List<String> queryFatherEntryIdList(List<Map<String, Object>> needLists, String fatherEntryIdName, String fathersFormId, String kingDeeLogName) {
        List<String> fatherEntryIdList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
            List<List<Object>> entryIdList = categoryDao.selectFatherEntryId(fatherEntryIdName, maps, fathersFormId, kingDeeLogName + "父单据行内码查询");
            String entryId = "0";
            //过滤掉查询不到FEntryID的数据返回"0"
            if (!CollectionUtils.isEmpty(entryIdList)) {
                if (entryIdList.size() >= Integer.parseInt(maps.get("PO_SEQ").toString())) {
                    entryId = entryIdList.get(Integer.parseInt(maps.get("PO_SEQ").toString()) - 1).get(0).toString();
                }
            } else {
                maps.put("notExitFBillNo", true);
            }
            //返回FEntryID默认值0说明查不到FEntryID
            if (!"0".equals(entryId)) {
                fatherEntryIdList.add(entryId);
                maps.put(maps.get("PO_CODE").toString() + "_" + maps.get("PO_SEQ").toString(), entryId);
            }
        }
        return fatherEntryIdList;
    }

    public String addTwo(List<Map<String, Object>> needList, String sFormId, String kingDeeLogName, List<Map<String, String>> fieldList, String entryName, boolean flag) {
        Map<String, Object> map = imsToKingDee(needList, fieldList, entryName);
        String result;
        if (flag) {
            List<String> fidList = needList.stream().map(m -> m.get("FID").toString()).distinct().collect(Collectors.toList());
            result = categoryDao.addAndWith(String.join(", ", fidList), sFormId, kingDeeLogName, JsonUtil.toString(map));
        } else {
            result = categoryDao.addTemp(sFormId, kingDeeLogName, JsonUtil.toString(map));
        }
        return result;
    }

    /**
     * ims字段转换成金蝶云待添加(其实都是下推后修改)字段
     */
    public Map<String, Object> imsToKingDee(List<Map<String, Object>> needList, List<Map<String, String>> fieldList, String entryName) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> modelMap = new HashMap<>(2);
        for (Map<String, Object> map : needList) {
            Map<String, Object> entityMap = new HashMap<>(10);
            for (Map<String, String> fieldMap : fieldList) {
                if ("true".equals(fieldMap.get("isDetail"))) {
                    if ("true".equals(fieldMap.get("isNumber"))) {
                        entityMap.put(fieldMap.get("kingdee"), new HashMap<String, Object>() {{
                            put("FNumber", map.get(fieldMap.get("ims")));
                        }});
                    } else {
                        entityMap.put(fieldMap.get("kingdee"), map.get(fieldMap.get("ims")));
                    }
                } else {
                    if ("true".equals(fieldMap.get("isNumber"))) {
                        modelMap.put(fieldMap.get("kingdee"), new HashMap<String, Object>(1) {{
                            put("FNumber", map.get(fieldMap.get("ims")));
                        }});
                    } else {
                        modelMap.put(fieldMap.get("kingdee"), map.get(fieldMap.get("ims")));
                    }
                }
            }
            /* 修改条件FEntryID */
            entityMap.put("FEntryID", map.get("FEntry_ID"));
            list.add(entityMap);

            /* 修改条件FID */
            modelMap.put("FID", map.get("FID"));
        }
        modelMap.put(entryName, list);

        return modelMap;
    }

    public void delete(List<String> fidList, String kingDeeLogName, String sFormId) {
        try {
            categoryDao.delete(kingDeeLogName, sFormId, String.join(", ", fidList));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
