package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author Inori
 */
@Component
public class ImsPayableKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;


    /**
     * 查询根据单据编码应付单行内码
     */
    public List<List<Object>> getEntryIdList(List<String> billNoList) {
        List<List<Object>> list = categoryDao.selectByListById("AP_Payable", new LinkedHashMap<String, String>(1) {{
            put("FEntityDetail_FEntryID", "FEntityDetail_FEntryID");
        }}, new HashMap<String, String>(1) {{
            put("FBillNo", String.join(", ", billNoList));
            put("FSetAccountType", "3");
        }});
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    /**
     * 查询根据源单编码应付单行内码
     */
    public List<List<Object>> getEntryIdListBySource(List<String> entryIdList) {
        List<List<Object>> list = categoryDao.selectByListById("AP_Payable", new LinkedHashMap<String, String>(1) {{
            put("FEntityDetail_FEntryID", "FEntityDetail_FEntryID");
        }}, new HashMap<String, String>(1) {{
            put("FEntityDetail_Link_FSId", String.join(", ", entryIdList));
            put("FSetAccountType", "2");
        }});
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    public String updateStatus(List<String> entryIdList) {
        return categoryDao.updateStatus("T_AP_PAYABLEENTRY", entryIdList);
    }

    public void updateSourceStatus(List<String> entryIdList) {
        categoryDao.updateStatus("T_AP_PAYABLEENTRY", entryIdList);
    }


}
