package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class ImsPickingListKingdeeApi {

    private static final String S_FORM_ID = "LQKJ_ContrastRecord";

    private Map<String, String> key = new LinkedHashMap<>();

    @Autowired
    private CategoryDao categoryDao;


    public ImsPickingListKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 采购编码 */
        key.put("F_LQKJ_Purchase", "F_LQKJ_Purchase");
        /* 物料编码 */
        key.put("F_LQKJ_FMaterial.Fnumber", "F_LQKJ_FMaterial.Fnumber");
        /* 要求送货数量 */
        key.put("F_LQKJ_PurchaseQty", "F_LQKJ_PurchaseQty");
        /* 供应商编码 */
        key.put("F_LQKJ_Supplier", "F_LQKJ_Supplier");
        /* 分析单 */
        key.put("F_LQKJ_NowLack", "F_LQKJ_NowLack");
        /* 单位 */
        key.put("F_LQKJ_Fstockunitid", "F_LQKJ_Fstockunitid");
        /* 采购订单行号 */
        key.put("F_LQKJ_PurchaseFsq", "F_LQKJ_PurchaseFsq");
        /* 需求日期 */
        key.put("F_LQKJ_NeedDate", "F_LQKJ_NeedDate");
        /* 源单单号 */
        key.put("F_LQKJ_XqBillno", "F_LQKJ_XqBillno");
        /* 源单物料 */
        key.put("F_LQKJ_XqMaterial", "F_LQKJ_XqMaterial");
        /* 发送总数 */
        key.put("F_LQKJ_PushCount", "F_LQKJ_PushCount");
    }

    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(S_FORM_ID, key, map, "提料分析单");
        return pojoToIms(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> pojoToIms(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> objectList : list) {
                    Map<String, String> map = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(objectList, 12, map, fieldList);

                    map.put("fid", objectList.get(0).toString());
                    map.put("poCode", objectList.get(1).toString());
                    map.put("mtrlCode", objectList.get(2).toString());
                    map.put("deliverableQty", objectList.get(3).toString());
                    map.put("supCde", objectList.get(4).toString());
                    map.put("supMtrlDtAnalNo", objectList.get(5).toString());
                    map.put("mUnit", objectList.get(6).toString());
                    map.put("poSeq", objectList.get(7).toString());
                    map.put("demandDate", objectList.get(8).toString());
                    map.put("sdlNo", objectList.get(9).toString());
                    map.put("sdlMtrl", objectList.get(10).toString());
                    map.put("pushCount", objectList.get(11).toString());
                    result.add(map);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message);
                result.add(salesordermap);
            }
        }
        return result;
    }


}
