package org.jeecg.modules.iost.ims.kingdeeapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonPush;
import org.jeecg.modules.iost.ims.mapper.ImsCommonPushMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class ImsPushConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private ImsCommonPushMapper imsCommonPushMapper;


    @PostConstruct
    public void init() {
        List<ImsCommonPush> imsCommonPushList = imsCommonPushMapper.selectList(null);
        for (ImsCommonPush imsCommonPush : imsCommonPushList) {
            this.map.put(imsCommonPush.getDocType(), addMap(imsCommonPush));
        }
    }

    public Map<String, String> get(String formId) {
        return map.get(formId);
    }

    public void set(String docType) {
        ImsCommonPush imsCommonPush = imsCommonPushMapper.selectOne(new QueryWrapper<ImsCommonPush>().eq("doc_type", docType));

        if (imsCommonPush != null) {
            this.map.remove(docType);

            this.map.put(imsCommonPush.getDocType(), addMap(imsCommonPush));
        }
    }

    private Map<String, String> addMap(ImsCommonPush imsCommonPush) {
        Map<String, String> temp = new HashMap<>(10);

        temp.put("docType", imsCommonPush.getDocType());
        temp.put("sFormId", imsCommonPush.getSFormId());
        temp.put("entryIdName", imsCommonPush.getEntryIdName());
        temp.put("fathersFormId", imsCommonPush.getFathersFormId());
        temp.put("fatherEntryIdName", imsCommonPush.getFatherEntryIdName());
        temp.put("pushRule", imsCommonPush.getPushRule());
        temp.put("linkFsIdName", imsCommonPush.getLinkFsIdName());
        temp.put("kingDeeLogName", imsCommonPush.getName());
        temp.put("kingDeeLogOztName", imsCommonPush.getOztName());
        temp.put("kingDeeLogPushName", imsCommonPush.getPushName());
        temp.put("detail", imsCommonPush.getDetail());

        return temp;
    }

    public void del(String docType) {
        this.map.remove(docType);
    }

    public void imsToKingDee(String docType, Map<String, Object> modelMap, Map<String, Object> fEntityMap, Map<String, Object> map) {
        System.out.println("<========imsToKingDee1");
        Map<String, String> tempMap = this.get(docType);
        System.out.println("<========imsToKingDee1.1:" + tempMap);
        if (!CollectionUtils.isEmpty(tempMap)) {
            List<Object> tempList = JsonUtil.toList(tempMap.get("detail"), Object.class);
            List<Map<String, String>> fieldList = tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());

            for (Map<String, String> fieldMap : fieldList) {
                if ("true".equals(fieldMap.get("isDetail"))) {
                    if ("true".equals(fieldMap.get("isNumber"))) {
                        fEntityMap.put(fieldMap.get("kingdee"), new HashMap<String, Object>() {{
                            put("FNumber", map.get(fieldMap.get("ims")));
                        }});
                    } else {
                        fEntityMap.put(fieldMap.get("kingdee"), map.get(fieldMap.get("ims")));
                    }
                } else {
                    if ("true".equals(fieldMap.get("isNumber"))) {
                        modelMap.put(fieldMap.get("kingdee"), new HashMap<String, Object>(1) {{
                            put("FNumber", map.get(fieldMap.get("ims")));
                        }});
                    } else {
                        modelMap.put(fieldMap.get("kingdee"), map.get(fieldMap.get("ims")));
                    }
                }
            }
        }
    }


}
