package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 查询金蝶云销售出库单基础信息
 */
@Component
public class ImsSalOutStockKingdeeApi {
    /**
     * 操作的单据体名称
     */
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId = "SAL_OUTSTOCK";//销售出库单基础信息
    private Map<String, String> key = new LinkedHashMap<>();

    public ImsSalOutStockKingdeeApi() {
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//单据编号
        key.put("FSaleOrgId.FNumber","FSaleOrgId.FNumber");//销售组织
        key.put("FSaleDeptID.FNumber","FSaleDeptID.FNumber");//销售部门
        key.put("FCustomerID.FNumber","FCustomerID.FNumber");//客户
        key.put("FSalesManID.FNumber","FSalesManID.FNumber");//销售员
        key.put("F_crh_BaseProperty ","F_crh_BaseProperty ");//最新销售员
        key.put("F_crh_BaseProperty1 ","F_crh_BaseProperty1 ");//最新销售部门
        key.put("FStockOrgId.FNumber","FStockOrgId.FNumber");//发货组织
        key.put("FMaterialID.FNumber","FMaterialID.FNumber");//物料编码
        key.put("FRealQty","FRealQty");//实发数量
        key.put("FStockID.FNumber","FStockID.FNumber");//仓库
    }

    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(sFormId, key, map, "销售出库单");
        return PojoToIMS(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()){
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> SaleList = new HashMap<>();
                String Sale = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 12, salesordermap, fieldList);

                    salesordermap.put("fid", list1.get(0).toString());//单据头实体主键
                    salesordermap.put("BillNo", list1.get(1).toString());//单据编号
                    salesordermap.put("FSaleOrgId", list1.get(2).toString());//销售组织
                    salesordermap.put("saleDeptId", list1.get(3).toString());//销售部门
                    salesordermap.put("customerId", list1.get(4).toString());//客户
                    salesordermap.put("salesManId", list1.get(5).toString());//销售员
                    salesordermap.put("lastSalesManId", list1.get(6).toString());//最新销售员
                    salesordermap.put("lastSaleDeptId", list1.get(7).toString());//最新销售部门
                    salesordermap.put("stockOrgId", list1.get(8).toString());//发货组织
                    salesordermap.put("materialId", list1.get(9).toString());//物料编码
                    salesordermap.put("realQty", list1.get(10).toString());//实发数量
                    salesordermap.put("stockId", list1.get(11).toString());//仓库

                    salesorderlist.add(salesordermap);
                }

            } else{
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));
                Map<String,String> error = new HashMap<>();
                error.put("false",message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }



}
