package org.jeecg.modules.iost.ims.kingdeeapi;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: ImsScrapReceiveConfirmController  报废品收料确认
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Component
@Data
public class ImsScrapReceiveConfirmApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private ImsPushConstants imsPushConstants;
    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    private String KingdeeLogOZTName;

    public ImsScrapReceiveConfirmApi() {
        sFormId = "STK_MISCELLANEOUS";  //子单据Formid
        KingdeeLogName = "其他入库单";    //金蝶云修改操作日志-nam
        KingdeeLogOZTName = "报废品收料确认";    //金蝶云修改操作日志对应欧智通-name
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    public Result addReturnResult(List<Map<String, Object>> lists, String docType) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists, docType);
        String result = categoryDao.addReturnResult(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        Result result1 = KingdeeResultParseUtil.parseAddResult(result);
        return result1;
    }

    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String, Object>> lists, String docType) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            //判断是否有新增字段
            imsPushConstants.imsToKingDee(docType, ModelMap, FEntityMap, maps);

            //字段转化
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_CODE"));
            }}); //收货仓库
            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_CODE"));
            }}); //物料编码
            FEntityMap.put("FQty", maps.get("QUANTITY")); //实收数量
            FEntityMap.put("FEntryNote", maps.get("REMARK")); //备注
            list.add(FEntityMap);
            ModelMap.put("FSTOCKERID", new HashMap<String, Object>() {{
                put("FNumber", maps.get("USER_CODE"));
            }}); //仓管员
            ModelMap.put("FSUPPLIERID", new HashMap<String, Object>() {{
                put("FNumber", maps.get("SUP_CODE"));
            }}); //供应商编码
            ModelMap.put("FStockOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //库存组织
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
        }
        ModelMap.put("FEntity", list);
        return ModelMap;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /*根据FID查询FEntity_FEntryId*/
    public String select(String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        String FEntity_FEntryId = categoryDao.Son_FindFentryId(SeqName, Son_FEnrtyID, Integer.valueOf(seq), FID, sFormId);
        return FEntity_FEntryId;
    }

    @Override
    public String update(
            Object object) {
        return null;
    }


}
