package org.jeecg.modules.iost.ims.kingdeeapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonSyn;
import org.jeecg.modules.iost.ims.mapper.ImsCommonSynMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class ImsSynConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private ImsCommonSynMapper imsCommonSynMapper;


    @PostConstruct
    public void init() {
        List<ImsCommonSyn> imsCommonSynList = imsCommonSynMapper.selectList(null);
        for (ImsCommonSyn imsCommonSyn : imsCommonSynList) {
            Map<String, String> temp = new HashMap<>(5);
            temp.put("formId", imsCommonSyn.getFormId());
            temp.put("docType", imsCommonSyn.getDocType());
            temp.put("name", imsCommonSyn.getName());
            temp.put("detail", imsCommonSyn.getDetail());
            this.map.put(imsCommonSyn.getFormId(), temp);
        }
    }

    public Map<String, String> get(String formId) {
        if (CollectionUtils.isEmpty(this.map)) {
            return new HashMap<>();
        }
        return this.map.get(formId);
    }

    public void set(String formId) {
        ImsCommonSyn imsCommonSyn = imsCommonSynMapper.selectOne(new QueryWrapper<ImsCommonSyn>().eq("form_id", formId));

        if (imsCommonSyn != null) {
            this.map.remove(formId);

            Map<String, String> temp = new HashMap<>(4);
            temp.put("formId", imsCommonSyn.getFormId());
            temp.put("docType", imsCommonSyn.getDocType());
            temp.put("name", imsCommonSyn.getName());
            temp.put("detail", imsCommonSyn.getDetail());
            this.map.put(imsCommonSyn.getFormId(), temp);
        }
    }

    public void del(String formId) {
        this.map.remove(formId);
    }

    public List<Map<String, String>> getFieldList(String formId) {
        List<Map<String, String>> fieldList = new ArrayList<>();
        Map<String, String> temp = this.get(formId);
        if (!CollectionUtils.isEmpty(temp)) {
            List<Object> objectList = JsonUtil.toList(temp.get("detail"), Object.class);
            fieldList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());
        }
        return fieldList;
    }

    public static void purchaseTo(Map<String, Object> dataMap, Map<String, Object> detailMap, Map<String, String> map, List<Map<String, String>> fieldList) {
        for (Map<String, String> temp : fieldList) {
            //是否是明细字段
            if ("true".equals(temp.get("isDetail"))) {
                if (detailMap != null) {
                    detailMap.put(temp.get("ims"), String.valueOf(map.get(temp.get("ims"))));
                }
            } else {
                dataMap.put(temp.get("ims"), String.valueOf(map.get(temp.get("ims"))));
            }
        }
    }

    public static void purchaseKingDee(Map<String, String> key, List<Map<String, String>> fieldList) {
        for (Map<String, String> map : fieldList) {
            String kingDee = map.get("kingdee");
            if ("true".equals(map.get("isNumber"))) {
                kingDee = kingDee + ".Fnumber";
            } else if ("true".equals(map.get("isName"))) {
                kingDee = kingDee + ".Fname";
            }
            key.put(kingDee, kingDee);
        }
    }

    public static void purchaseIms(List<Object> objectList, int index, Map<String, String> map, List<Map<String, String>> fieldList) {
        for (int i = 0; i < fieldList.size(); i++) {
            //是否是明细字段
            map.put(fieldList.get(i).get("ims"), String.valueOf(objectList.get(index + i)));
        }
    }


}
