package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class PurchaseReturnKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;

    private static final String S_FORM_ID = "PUR_MRB";

    private Map<String, String> key = new LinkedHashMap<>();

    public PurchaseReturnKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 单据编号 */
        key.put("FBillNo", "FBillNo");
        /* 单据类型 */
        key.put("FBillTypeID.Fname", "FBillTypeID.Fname");
        /* 行号 */
        key.put("FPURMRBENTRY_FSeq", "FPURMRBENTRY_FSeq");
        /* 供应商 */
        key.put("FSupplierId.Fnumber", "FSupplierId.Fnumber");
        /* 退料时间 */
        key.put("FDate", "FDate");
        /* 税额 */
        key.put("FBillTaxAmount", "FBillTaxAmount");
        /* 未税金额 */
        key.put("FBillAmount", "FBillAmount");
        /* 含税否 */
        key.put("FIsIncludedTax", "FIsIncludedTax");
        /* 汇率 */
        key.put("FExchangeRate", "FExchangeRate");
        /* 税价合计 */
        key.put("FBillAllAmount", "FBillAllAmount");
        /* 付款条件 */
        key.put("FPayConditionId.Fname", "FPayConditionId.Fname");
        /* 结算币别 */
        key.put("FSettleCurrId.Fname", "FSettleCurrId.Fname");
        /* 结算方式 */
        key.put("FSettleTypeId.Fname", "FSettleTypeId.Fname");
        /* 采购员 */
        key.put("FPurchaserId.Fname", "FPurchaserId.Fname");
        /* 物料编码 */
        key.put("FMaterialId.Fnumber", "FMaterialId.Fnumber");
        /* 计价数量 */
        key.put("FPriceUnitQty", "FPriceUnitQty");
        /* 单价 */
        key.put("FPrice", "FPrice");
        /* 含税单价 */
        key.put("FTaxPrice", "FTaxPrice");
        /* 计价单位 */
        key.put("FPriceUnitID.Fname", "FPriceUnitID.Fname");
        /* 税率 */
        key.put("FEntryTaxRate", "FEntryTaxRate");
        /* 折扣额 */
        key.put("FDiscount", "FDiscount");
        /* 金额 */
        key.put("FAmount", "FAmount");
        /* 采购订单分录内码 */
        key.put("FPOORDERENTRYID", "FPOORDERENTRYID");
        /* 行内码 */
        key.put("FPURMRBENTRY_FEntryID", "FInStockEntry_FEntryID");
        /* 税额 */
        key.put("FENTRYTAXAMOUNT", "FENTRYTAXAMOUNT");
        /* 价税合计 */
        key.put("FALLAMOUNT", "FALLAMOUNT");
    }

    /**
     * 查询采购订单编号+行号
     */
    public List<List<Object>> getPurchaseOrder(List<String> entryIdList) {
        List<List<Object>> list = categoryDao.selectByList("PUR_PurchaseOrder", new LinkedHashMap<String, String>(3) {{
            put("FBillNo", "FBillNo");
            put("FPOOrderEntry_FSeq", "FPOOrderEntry_FSeq");
            put("FPOOrderEntry_FEntryID", "FPOOrderEntry_FEntryID");
        }}, new HashMap<String, String>(1) {{
            put("FPOOrderEntry_FEntryID", String.join(", ", entryIdList));
        }});
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    /**
     * 查询供应商发票类型
     */
    public List<List<Object>> getSupplier(List<String> numberList) {
        List<List<Object>> list = categoryDao.selectByList("BD_Supplier", new LinkedHashMap<String, String>(2) {{
            put("FInvoiceType", "FInvoiceType");
            put("FNumber", "FNumber");
        }}, new HashMap<String, String>(1) {{
            put("FNumber", String.join(", ", numberList));
        }});
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return list;
    }

    /**
     * 获取金蝶云数据
     */
    public List<Map<String, Object>> selectAndLog(Map<String, String> map, String name) {
        List<List<Object>> list = categoryDao.selectDate(S_FORM_ID, key, map, name);
        return purchaseWarehousing(list);
    }

    private List<Map<String, Object>> purchaseWarehousing(List<List<Object>> list) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                List<String> codeList = list.stream().map(m -> m.get(1).toString()).distinct().collect(Collectors.toList());
                List<String> entryIdList = list.stream().map(m -> m.get(23).toString()).distinct().collect(Collectors.toList());
                List<List<Object>> purchaseOrderList = getPurchaseOrder(entryIdList);
                List<String> numberList = list.stream().map(m -> m.get(4).toString()).distinct().collect(Collectors.toList());
                List<List<Object>> supplierList = getSupplier(numberList.stream().map(m -> "'" + m + "'").collect(Collectors.toList()));
                for (String code : codeList) {
                    List<List<Object>> collect = list.stream().filter(m -> code.equals(m.get(1).toString())).collect(Collectors.toList());

                    Map<String, Object> map = new HashMap<>();
                    List<Map<String, Object>> mapList = new ArrayList<>();
                    for (List<Object> objectList : collect) {
                        map.put("RETURN_MATERIAL_CODE", objectList.get(1));
                        map.put("RETURN_MATERIAL_TYPE", String.valueOf(objectList.get(2)));
                        map.put("SUPPLIER_CODE", String.valueOf(objectList.get(4)));
                        Date parse = null;
                        try {
                            parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(String.valueOf(objectList.get(5))));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        map.put("RETURN_MATERIAL_DATE", parse);
                        map.put("TAX_AMOUNT", "-" + objectList.get(6));
                        map.put("AMOUNT", "-" + objectList.get(7));
                        map.put("TAX_INCLUDED", String.valueOf(objectList.get(8)));
                        map.put("EXCHANGE_RATE", String.valueOf(objectList.get(9)));
                        map.put("ALL_AMOUNT", "-" + objectList.get(10));
                        map.put("PAYMENT_TERMS", String.valueOf(objectList.get(11)));
                        map.put("CURRENCY", String.valueOf(objectList.get(12)));
                        map.put("SETTLEMENT_METHOD", String.valueOf(objectList.get(13)));
                        map.put("BUYER", String.valueOf(objectList.get(14)));
                        List<List<Object>> invoiceTypeList = supplierList.stream().filter(m -> objectList.get(4).equals(m.get(1))).collect(Collectors.toList());
                        if ("1".equals(String.valueOf(invoiceTypeList.get(0).get(0)))) {
                            map.put("INVOICE_TYPE", "增值税专用发票");
                        } else if ("2".equals(String.valueOf(invoiceTypeList.get(0).get(0)))) {
                            map.put("INVOICE_TYPE", "普通发票");
                        }

                        Map<String, Object> detailedMap = new HashMap<>(7);
                        detailedMap.put("RETURN_MATERIAL_NO", objectList.get(1) + "_" + objectList.get(3));
                        detailedMap.put("MATERIAL_CODE", String.valueOf(objectList.get(15)));
                        detailedMap.put("ACTUAL_RETURNED_QTY", "-" + objectList.get(16));
                        detailedMap.put("PRICE", String.valueOf(objectList.get(17)));
                        detailedMap.put("TAX_PRICE", String.valueOf(objectList.get(18)));
                        detailedMap.put("UNIT", String.valueOf(objectList.get(19)));
                        detailedMap.put("TAX_RATE", String.valueOf(objectList.get(20)));
                        detailedMap.put("DISCOUNT_AMOUNT", "-" + objectList.get(21));
                        detailedMap.put("AMOUNT", "-" + objectList.get(22));
                        detailedMap.put("RETURN_MATERIAL_ENTRY_ID", String.valueOf(objectList.get(24)));
                        detailedMap.put("TAX_AMOUNT", "-" + objectList.get(25));
                        detailedMap.put("ALL_AMOUNT", "-" + objectList.get(26));
                        List<List<Object>> tempList = purchaseOrderList.stream().filter(m -> objectList.get(23).equals(m.get(2))).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(tempList)) {
                            detailedMap.put("PURCHASE_BATCH_NUMBER", tempList.get(0).get(0).toString() + "_" + tempList.get(0).get(1).toString());
                        }
                        mapList.add(detailedMap);
                    }
                    map.put("RECORDS", mapList);
                    result.add(map);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, Object> resultMap = new HashMap<>(1);
                resultMap.put("false", message);
                result.add(resultMap);
            }
        }
        return result;
    }

    public String updateStatus(List<String> entryIdList) {
        return categoryDao.updateStatus("T_PUR_MRBENTRY", entryIdList);
    }


}
