package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云IMS同步基本信息
 */
@Component
public class SynKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "LQKJ_IMSSync";//同步记录表
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public SynKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("F_LQKJ_SyncDataId","F_LQKJ_SyncDataId");//同步记录数据内码
        key.put("F_LQKJ_Syncbill","F_LQKJ_Syncbill");//同步记录表单
        key.put("F_LQKJ_SyncCheck","F_LQKJ_SyncCheck");//同步
        key.put("F_LQKJ_SyncDataEntryId","F_LQKJ_SyncDataEntryId");//行内吗
    }
    @Override
    public String add(Map json) {
        String add = categoryDao.add(sFormId,JsonUtil.Mapjson(json));
        return add;
    }
    public String batchAdd(List json) {
        String add = categoryDao.batchAdd(sFormId,JsonUtil.Listjson(json));
        return add;
    }
    /**
     * 查询同步为0的数据
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        //查询未同步数据
        List<List<Object>> list = categoryDao.selectSyn(sFormId, key, new HashMap<String, String>() {{
            put("F_LQKJ_SyncCheck","0");
        }});
        return Syn(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> Syn(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            for (List<Object> list1 : list) {
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("fid", list1.get(0).toString());
                salesordermap.put("dataid", list1.get(1).toString());
                salesordermap.put("formid", list1.get(2).toString());
                salesordermap.put("synchronization", list1.get(3).toString());
                salesordermap.put("entryId", list1.get(4).toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
