package org.jeecg.modules.iost.ims.kingdeeapi;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 查询金蝶云调拨申请单
 */
@Slf4j
@Component
public class WmsAllotKingdeeApi {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "STK_TRANSFERAPPLY";//调拨申请单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public WmsAllotKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FBillNo", "FBillNo");//编码
        key.put("FStockInId.Fnumber", "FStockInId.Fnumber");//调入仓库编码
        key.put("FStockId.Fnumber", "FStockId.Fnumber");//调出仓库编码
        key.put("FStockOrgInId.Fnumber", "FStockOrgInId.Fnumber");//调入组织编码
        key.put("FStockOrgId.Fnumber", "FStockOrgId.Fnumber");//调出组织编码
        key.put("FTRANSTYPE", "FTRANSTYPE");//调拨类型
        key.put("FMATERIALID.Fnumber", "FMATERIALID.Fnumber");//物料编码
        key.put("FQty", "FQty");//申请数量
        key.put("FNote", "FNote");//备注
        key.put("FEntity_FSeq", "FEntity_FSeq");//行号
    }

    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(sFormId, key, map, "调拨申请单");
        return PojoToIMS(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    System.out.println("<========PojoToIMS"+list1);
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 11, salesordermap, fieldList);

                    salesordermap.put("fid", valueOf(list1.get(0)));
                    salesordermap.put("orgId", valueOf(list1.get(4)));
                    salesordermap.put("allotCode", valueOf(list1.get(1)));
                    if (null == list1.get(3)) {
                        salesordermap.put("srcStoreCode", "");
                    } else {
                        salesordermap.put("srcStoreCode", valueOf(list1.get(3)));
                    }
                    salesordermap.put("toOrgId", valueOf(list1.get(5)));
                    salesordermap.put("toStoreCode", valueOf(list1.get(2)));
                    salesordermap.put("allotType", valueOf(list1.get(6)));
                    salesordermap.put("mtrlCode", valueOf(list1.get(7)));
                    salesordermap.put("allotQty", valueOf(list1.get(8)));
                    if (null == list1.get(9)) {
                        salesordermap.put("remark", "");
                    } else {
                        salesordermap.put("remark", valueOf(list1.get(9)));
                    }
                    salesordermap.put("thirdRwn", valueOf(list1.get(10)));
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> error = new HashMap<>(1);
                error.put("false", message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }

    String valueOf(Object ob) {
        return null == ob ? "" : ob.toString();
    }
}
