package org.jeecg.modules.iost.ims.kingdeeapi;

import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
@Data
public class WmsRoKingdeeApi {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "SAL_RETURNNOTICE";//退货通知单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public WmsRoKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FSaleOrgId.Fnumber", "FSaleOrgId.Fnumber");//销售组织
        key.put("FBillNo", "FBillNo");//编码
        key.put("FBillTypeID.Fnumber", "FBillTypeID.Fnumber");//单据类型
        key.put("FQty", "FQty");//销售数量
        key.put("FMaterialId.Fnumber", "FMaterialId.Fnumber");//物料编码
        key.put("FStockId.Fnumber", "FStockId.Fnumber");//仓库编码
        key.put("FEntity_FENTRYID", "FEntity_FENTRYID");//行内码
        key.put("FRetcustId.Fnumber", "FRetcustId.Fnumber");//供应商编码
        key.put("FEntity_FSeq", "FEntity_FSeq");//行号
    }

    public List<Map<String, String>> select(Map<String, String> map, String where, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(sFormId, key, map, "退货通知单");
        return PojoToIMS(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 10, salesordermap, fieldList);

                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    salesordermap.put("roCode", list1.get(2).toString());
                    salesordermap.put("roType", list1.get(3).toString());
                    salesordermap.put("mqty", list1.get(4).toString());
                    salesordermap.put("mtrlCode", list1.get(5).toString());
                    salesordermap.put("storeCode", list1.get(6).toString());
                    salesordermap.put("FEntity_FENTRYID", list1.get(7).toString());
                    salesordermap.put("supCode", list1.get(8).toString());
                    salesordermap.put("roMtrlSeq", list1.get(9).toString());
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> error = new HashMap<>();
                error.put("false", message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }


}
