package org.jeecg.modules.iost.ims.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsSalOutStock;

import java.util.List;
import java.util.Map;

/**
 * @Description: 销售出库单
 * @Author: jeecg-boot
 * @Date: 2023-4-23
 * @Version: V1.0
 */

public interface IImsSalOutStockService extends IService<ImsSalOutStock> {

    Boolean synchronization(Object dataId, Object formId, LoginUser sysUser);

    /**
     * 审核销售出库单判断是否为终审或最后一个代办消息
     *
     * @param list
     * @param formName
     * @return
     */
    String audit(List<Map<String, Object>> list,String formName);

    /**
     * 返回是否可以撤销销售出库单
     *
     * @param formName
     * @param numbers
     * @return
     */
    Map<String, Object> cancelAssign(String formName, List<String> numbers);

}
