package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.BillOfMaterialKingDeeApi;
import org.jeecg.modules.iost.ims.service.IBillOfMaterialServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
@Slf4j
public class BillOfMaterialServerImpl implements IBillOfMaterialServer {

    @Autowired
    private BillOfMaterialKingDeeApi billOfMaterialKingDeeApi;


    @Override
    public String setData(List<Map<String, Object>> list, String docType) {
        //测试生产用料清单
        System.out.println("setData---list:"+JSON.toJSONString(list));
        System.out.println("setData---docType:"+docType);

        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", "生产用料清单");
        ThreadLocalConfig.set(map2);

        new ImsLogUtil().ImsRequestLog(JSON.toJSONString(list), "生产用料清单", "生产用料清单", docType);

        String addTwo = billOfMaterialKingDeeApi.addTwo(list);
        log.info("addTwo_" + String.valueOf(addTwo));
        Map<String, Object> map = JsonUtil.toMap(addTwo, String.class, Object.class);
        if (CollectionUtils.isEmpty(map)) {
            throw new kingdeeException("操作失败!更新失败!", addTwo, docType);
        }
        if (!CollectionUtils.isEmpty(map) && !"0000".equals(map.get("resultCode"))) {
            List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get("resultData")), Object.class);
            List<String> msgList = tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class).get("msg").toString()).collect(Collectors.toList());
            log.info("wss_msgList" + String.valueOf(msgList));
            String message;
            if (!CollectionUtils.isEmpty(msgList)) {
                message = String.join(", ", msgList);
            } else {
                message = String.valueOf(map.get("resultMsg"));
            }
            throw new kingdeeException("操作失败!修改失败!", message, docType);
        }

        List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get("resultData")), Object.class);
        log.info("tempList_"+ String.valueOf(tempList));
        List<String> codeList = tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class).get("code").toString()).collect(Collectors.toList());
        log.info("codeList_"+ String.valueOf(codeList));
        return String.join(", ", codeList);
    }


}
