package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsSalOutStock;
import org.jeecg.modules.iost.ims.entity.ImsWmsAudit;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSalOutStockKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.mapper.ImsSalOutStockMapper;
import org.jeecg.modules.iost.ims.service.IImsSalOutStockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Description: 销售出库单
 * @Author: jeecg-boot
 * @Date: 2023-4-23
 * @Version: V1.0
 */

@Service
public class IImsSalOutStockServiceImpl extends ServiceImpl<ImsSalOutStockMapper, ImsSalOutStock> implements IImsSalOutStockService {

    @Autowired
    ImsSalOutStockKingdeeApi kingdeeApi;

    @Autowired
    IMSApi imsApi;

    @Autowired
    private ImsSynConstants imsSynConstants;

    @Autowired
    private CategoryDao categoryDao;

    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "销售出库单";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsWmsAudit> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        Map<String, Object> datalist = new HashMap<>();
        List<Map<String, Object>> bsList = new ArrayList<>();
        List<Map<String, String>> bsStoreList = new ArrayList<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //封装单据的物料明细信息
            Map<String, Object> wms_allot_mtrl = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, wms_allot_mtrl, data, fieldList);
            wms_allot_mtrl.put("mtrl_code", data.get("materialId"));//物料编码
            wms_allot_mtrl.put("tn_qty", data.get("realQty"));//实发数量
            bsList.add(wms_allot_mtrl);

            //封装明细信息中的仓库明细
            Map<String, String> bs_mn_store = new HashMap<>();
            bs_mn_store.put("store_code", data.get("stockId"));//仓库编码
            bsStoreList.add(bs_mn_store);

            datalist.put("pmn_id", data.get("fid"));//销售出库单ID
            datalist.put("pmn_code", data.get("BillNo"));//销售出库单编码
            datalist.put("pmn_type", 11);//出库单类型
            datalist.put("org_id", data.get("FSaleOrgId"));//销售组织
            datalist.put("dept_id", data.get("saleDeptId"));//销售部门
            datalist.put("cust_code", data.get("customerId"));//客户
            datalist.put("saleMan_id", data.get("salesManId"));//销售员
            datalist.put("LastSaleMan_id", data.get("lastSalesManId"));//最新销售员
            datalist.put("LastsaleDept_id", data.get("lastSaleDeptId"));//最新销售员
            datalist.put("stockOrg_id", data.get("stockOrgId"));//发货组织
        }
        datalist.put("bs_mn_mtrl", bsList);
        datalist.put("bs_mn_store", bsStoreList);
        imsList.add(datalist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "WMS_MN");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "销售出库单", "WMS_MN");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "销售出库单", "WMS_MN", null);
        //设置同步成功状态
        success = flag;
        return success;
    }

    @Override
    public String audit(List<Map<String, Object>> list, String code) {
        //标识是否审核成功
        Boolean flag = false;
        //结果
        Map<String, Object> result = new HashMap<>();
        //获取传入参数
        List<String> numbers = new ArrayList<>();
        for (Map<String, Object> map : list) {
            numbers.add(map.get("numbers").toString());
        }
        //调用金蝶审核接口
        String autoidResult = categoryDao.audit("SAL_OUTSTOCK", numbers);
        JSONObject jsonObject = JSONObject.parseObject(autoidResult);
        jsonObject = (JSONObject) jsonObject.get("Result");
        jsonObject = (JSONObject) jsonObject.get("ResponseStatus");
        //根据返回值判断审核是否成功
        if ("false".equals(jsonObject.get("IsSuccess").toString())) {
            //审核失败
            //由于多数据审核的情况下，部分审核成功也会返回审核失败
            //所以需要根据是否有成功消息来判断是否有数据审核成功
            if (!"[]".equals(jsonObject.get("SuccessMessages").toString())) {
                //成功消息不为空，代表部分数据审核成功,返回成功和错误的消息
                JSONArray successJsonArray = (JSONArray) jsonObject.get("SuccessMessages");
                //可能有多条成功数据，拼接后返回
                StringBuilder successStr = new StringBuilder();
                for (Object successMsg : successJsonArray) {
                    JSONObject successObject = (JSONObject) successMsg;
                    successStr.append(successObject.get("Message").toString());
                }
                result.put("successMessages", successStr.toString());
            }
            //返回错误信息
            //可能有多条成功数据，拼接后返回
            StringBuilder errorStr = new StringBuilder();
            JSONArray errorJsonArray = (JSONArray) jsonObject.get("Errors");
            for (Object errorMsg : errorJsonArray) {
                JSONObject errorJsonObject = (JSONObject) errorMsg;
                errorStr.append(errorJsonObject.get("Message").toString());
            }
            result.put("errorMessages", errorStr);
            result.put("success", flag);
            String message = "";
            if (!Objects.isNull(result.get("successMessages"))){
                //部分审核成功，拼接成功和失败信息并返回
                message = result.get("successMessages").toString()+errorStr;
            }else {
                //全部审核失败，返回错误信息
                message = errorStr.toString();
            }
            //审核失败,返回失败结果
            throw new kingdeeException("审核失败!", message, code);
        }
        //审核成功,返回成功消息
        flag = true;
        result.put("success", flag);
        return "审核成功";
    }

    @Override
    public Map<String, Object> cancelAssign(String formName, List<String> numbers) {
        //标识是否撤销成功
        Boolean flag = false;
        //记录日志
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        //结果
        Map<String, Object> result = new HashMap<>();
        //首先调用IMS的删除出库单接口
        Map<String, Object> datalist = new HashMap<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (String number : numbers) {
            datalist = new HashMap<>();
            datalist.put("org_id", "100");
            datalist.put("pmn_code", number);
            datalist.put("pmn_type", 11);
            imsList.add(datalist);
        }
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "WMS_MN");
        map.put("updateType", "DELETE");
        map.put("data", imsList);
        String mapjson = JSONObject.toJSONString(map);
        String imsDeleteResult = imsApi.delete(mapjson, "销售出库单", "WMS_MN");
        //将结果转换为JSONObject
        JSONObject jsonObject = JSONObject.parseObject(imsDeleteResult);
        //判断IMS删除出库单记录是否成功
        if (!"0000".equals(jsonObject.get("resultCode"))) {
            //IMS删除出库单失败，判断错误信息是否是单据不存在
            String resultMsg = jsonObject.get("resultMsg").toString();
            if (!resultMsg.contains("未定义!")) {
                //其他错误,则中断流程记录日志并返回错误信息
                imsLogUtil.ImsLog(mapjson, imsDeleteResult, "销售出库单", "WMS_MN", resultMsg);
                result.put("success", flag);
                result.put("msg", resultMsg);
                return result;
            }
            //如果是则认为IMS单据已删除，金蝶对应单据可以撤销
        }
        //删除IMS出库单成功，记录日志，改变标识
        imsLogUtil.ImsLog(mapjson, imsDeleteResult, "销售出库单", "WMS_MN", null);
        flag = true;
        result.put("success", flag);
        return result;
    }

}
