package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.ImmediateInventoryKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImmediateInventoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class ImmediateInventoryServiceImpl implements IImmediateInventoryService {

    @Autowired
    private ImmediateInventoryKingdeeApi immediateInventoryKingdeeApi;


    @Override
    public Map<String, Object> getData(Map<String, Object> map) {
        Map<String, Object> result = new HashMap<>(1);

        String kingDeeLogOZTName = "即时库存查询";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);

        //记录IMS日志
        new ImsLogUtil().ImsRequestLog(JsonUtil.toString(map), "即时库存", "即时库存查询", "STK_Inventory");

        Map<String, String> whereMap = new HashMap<>(4);
        if (map.containsKey("MTRL_CODE")) {
            whereMap.put("FMaterialId.Fnumber", String.valueOf(map.get("MTRL_CODE")));
        }
        if (map.containsKey("MTRL_NAME")) {
            whereMap.put("FMaterialName", String.valueOf(map.get("MTRL_NAME")));
        }
        if (map.containsKey("STORE_CODE")) {
            whereMap.put("FStockId.Fnumber", String.valueOf(map.get("STORE_CODE")));
        }

        if (CollectionUtils.isEmpty(whereMap)) {
            result.put("false", "查询参数不能全为空");
            return result;
        }
        List<Map<String, Object>> list = immediateInventoryKingdeeApi.selectAndLog(whereMap, "即时库存查询");


        if (!CollectionUtils.isEmpty(list)) {
            if (list.get(0).containsKey("false")) {
                result.put("false", list.get(0).get("false"));
            } else {
                result.put("true", list);
            }
        } else {
            result.put("true", list);
        }
        return result;
    }


}
