package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.*;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsAsnReceiveConfirmApi;
import org.jeecg.modules.iost.ims.service.ImsAsnReceiveConfirmService;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.entity.ImsAsnReceiveConfirm;
import org.jeecg.modules.iost.ims.mapper.ImsAsnReceiveConfirmMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ImsAsnReceiveConfirm  ASN收料确认
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsAsnReceiveConfirmServiceImpl extends ServiceImpl<ImsAsnReceiveConfirmMapper, ImsAsnReceiveConfirm> implements ImsAsnReceiveConfirmService {
    @Autowired
    ImsAsnReceiveConfirmApi ImsAsnReceiveConfirmApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;
    private String wipOrde;
    private String imsLogOZTNmae;

    public ImsAsnReceiveConfirmServiceImpl() {
        this.imsLogName = "采购入库单";  //ims日志-name(excal表里面金蝶那一列名字)
        this.imsLogOZTNmae = "ASN收料确认";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "BS0009";  //调用者传入的标识
        this.SEQ = "PO_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
        this.wipOrde = "PO_CODE";  //父亲单据工单编号或者行内码
    }

    public String setData(List<Map<String, Object>> needLists, String code) {

        //追加参数(上下文对象)
        String kingdeeLogOZTName = ImsAsnReceiveConfirmApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        map2.put("SEQ", SEQ);
        map2.put("wipOrde", wipOrde);
        ThreadLocalConfig.set(map2);
        //业务开始
        List<ImsAsnReceiveConfirm> ImsAsnReceiveConfirms = new ArrayList<>();
        //查询父单据失败的lists
        List<Map<String, Object>> SelectFatherFentryIdFailLists = new ArrayList();
        //查询父单据失败的返回结果
        List<String> SelectFatherFentryIdFailResult = new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult = new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
            //打印测试信息
            try {
                System.out.println(getCurrentTime()+" "+code+"业务开始,父单据编码为:"+maps.get("PO_CODE").toString()+",唯一标识为:"+maps.get("QUEUE_ID").toString());
            } catch (Exception e) {
                System.out.println("打印测试信息失败");
                e.printStackTrace();
            }
        }
        QueryWrapper<ImsAsnReceiveConfirm> qw = new QueryWrapper();
        qw.in("queue_id", qidList);
        StringBuilder builder = new StringBuilder();
        int length = qidList.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append("'" + qidList.get(i) + "'");
            } else {
                builder.append(",").append("'" + qidList.get(i) + "'");
            }
        }
        qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
        List<ImsAsnReceiveConfirm> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            System.out.println("报废品/不良品收料确认queue_id查询操作"+repeatLists);
            System.out.println(queue_idRepeatResult);
            queue_idRepeatResult = ResultSplitOne(repeatLists);
        }
        if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
        }
        //判断需要修改的needLists里面有没有元素，有元素说明有东西未修改过，没有说明添加进来的数据都已经修改过了
        List<String> Father_FEntryIDs = new ArrayList<>();
        if (!ObjectUtils.isEmpty(needLists)) {
            Father_FEntryIDs = ImsAsnReceiveConfirmApi.queryFatherFEntryIDs(needLists, SelectFatherFentryIdFailLists);
            SelectFatherFentryIdFailResult = ResultSplitTwo(SelectFatherFentryIdFailLists);
        }
        if (!CollectionUtils.isEmpty(SelectFatherFentryIdFailResult)) {
            throw new kingdeeException("操作失败!", SelectFatherFentryIdFailResult, code);
        }
        //下推前查询当前单据的所有下推单据
        try {
            ImsAsnReceiveConfirmApi.selectAllPush(needLists);
        } catch (Exception e) {
            System.out.println("下推单据查询失败");
            e.printStackTrace();
        }
        //下推失败返回结果
        List<String> pushResultLists = new ArrayList<>();
        List<String> AddResultLists = new ArrayList();
        org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult = new org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result();
        if (!ObjectUtils.isEmpty(needLists)) {
            org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result result = null;
            try {
                //打印测试信息
                System.out.println(getCurrentTime()+" "+code+"下推开始，下推数据为:"+needLists);
                result = ImsAsnReceiveConfirmApi.push(needLists, Father_FEntryIDs);
                pushResultLists = ResultSplitThree(result);
            } catch (Exception e) {
                //如果下推错误，打印异常信息
                System.out.println(getCurrentTime()+" "+code+"下推异常,父数据为"+needLists+"错误信息为:");
                e.printStackTrace();
            }
            if (!CollectionUtils.isEmpty(pushResultLists)) {
                //打印测试信息
                System.out.println(getCurrentTime()+" "+code+"下推失败"+pushResultLists);
                throw new kingdeeException("操作失败!下推失败!", pushResultLists, code);
            }
            //打印下推成功数据
            System.out.println(getCurrentTime()+" "+code+"下推成功，父单据数据为"+needLists+"下推子单据数据为"+result.getResponseStatus().getSuccessEntitys());
            //查询子单据行内码maps.get("AUDIT_ID").toString()+maps.get("AUDIT_SEQ").toString()
            for (Map<String, Object> needmap : needLists) {
                String Son_FEntry_ID = ImsAsnReceiveConfirmApi.querySonFEntryID(needmap.get(needmap.get(wipOrde).toString() + needmap.get(SEQ).toString()).toString(), needmap.get(SEQ).toString(), result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FEntry_ID", Son_FEntry_ID);

            }
            //修改成功下推后needPushLists的数据
            AddResult = ImsAsnReceiveConfirmApi.addTwo(needLists, code);
            if (AddResult.getResponseStatus().getIsSuccess()) {
                for (Map<String, Object> needmap : needLists) {
                    needmap.put("FBILL_NO", AddResult.getNumber());
                    //Map传入参数大写字段转化为实体类字段
                    Map<String, Object> map = MapUtils.mapsChange(needmap);
                    ImsAsnReceiveConfirm ImsAsnReceiveConfirm = JSON.parseObject(JSON.toJSONString(map), ImsAsnReceiveConfirm.class);//map转为实体类对象
                    ImsAsnReceiveConfirms.add(ImsAsnReceiveConfirm);
                }
            }
            AddResultLists = ResultSplitFour(AddResult);
            if (!CollectionUtils.isEmpty(AddResultLists)) {
                throw new kingdeeException("操作失败!修改失败!", AddResultLists, code);
            }
        }
        //保存实体类
        try {
            this.saveBatch(ImsAsnReceiveConfirms);
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(getCurrentTime()+" "+code+"保存数据库异常");
        }
        return ImsAsnReceiveConfirms.get(0).getFbillNo();
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitThree(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result pushResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = pushResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = pushResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitTwo(List<Map<String, Object>> SelectFatherFentryIdFailLists) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        List<String> rustListAfter = new ArrayList<>();
        for (Map<String, Object> queue_idRepeatResultMap : SelectFatherFentryIdFailLists) {
            if (!ObjectUtils.isEmpty(queue_idRepeatResultMap.get("notExitFbillNo")) && Boolean.valueOf(queue_idRepeatResultMap.get("notExitFbillNo").toString()) == true) {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "单据" + queue_idRepeatResultMap.get(wipOrde) + "不存在，无法进行下推修改!";
                rustList.add(result);
            } else {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "唯一序号为(" + queue_id + ")且行号为(" + queue_idRepeatResultMap.get(SEQ) + ")的数据不存在，无法进行下推修改!";
                rustList.add(result);
            }
        }
        HashSet<String> set = new LinkedHashSet();
        for (String s : rustList) {
            set.add(s);
        }
        for (String s : set) {
            rustListAfter.add(s);
        }
        return rustListAfter;
    }

    public List<String> ResultSplitOne(List<ImsAsnReceiveConfirm> repeatLists) {
        String result = new String();
        LinkedHashSet<String> hashset = new LinkedHashSet<>();
        for (ImsAsnReceiveConfirm ImsAsnReceiveConfirm : repeatLists) {
            String queue_id = String.valueOf(ImsAsnReceiveConfirm.getQueueId());
            result = "QUEUE_ID为(" + queue_id + ")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList = new ArrayList<>();
        String result2 = new String();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

    public String getCurrentTime(){
        Date date = new Date();
        SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return dateFormat.format(date);
    }
}
