package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsBom;
import org.jeecg.modules.iost.ims.kingdeeapi.BsBomKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.mapper.ImsBsBomMapper;
import org.jeecg.modules.iost.ims.service.IImsBsBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: bom基础信息
 * @Author: jeecg-boot
 * @Date: 2021-12-20
 * @Version: V1.0
 */
@Service
public class ImsBsBomServiceImpl extends ServiceImpl<ImsBsBomMapper, ImsBsBom> implements IImsBsBomService {

    @Autowired
    BsBomKingdeeApi kingdeeApi;

    @Autowired
    IMSApi imsApi;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "BOM信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        ThreadLocalConfig.set(map2);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsBsBom> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = true;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        List<Map<String, Object>> bsList = new ArrayList<>();
        Map<String, Object> datalist = new HashMap<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsBsBom pojo = new ImsBsBom();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setProdCode(data.get("prodCode"));
            pojo.setBomVer(data.get("bomVer"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setIsMain(data.get("isMain"));
            pojo.setMainCode(data.get("mainCode"));
            pojo.setDosage(data.get("dosage"));
            pojo.setPointStr(data.get("pointStr"));
//            pojo.setRemark(data.get("remark"));
            pojo.setCreateTime(new Date());
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);

            //封装成IMS格式
            Map<String, Object> bs_bom_mtrl = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, bs_bom_mtrl, data, fieldList);

            bs_bom_mtrl.put("mtrl_code", data.get("mtrlCode"));
            bs_bom_mtrl.put("is_main", data.get("isMain"));
            bs_bom_mtrl.put("main_code", data.get("mainCode"));
            bs_bom_mtrl.put("dosage", new BigDecimal(data.get("dosage")));
            bs_bom_mtrl.put("point_str", data.get("pointStr"));
            bsList.add(bs_bom_mtrl);

            datalist.put("org_id", data.get("orgId"));
            datalist.put("prod_code", data.get("prodCode"));
            datalist.put("bom_ver", data.get("bomVer"));
            datalist.put("remark", "");
        }
        datalist.put("bs_bom_mtrl", bsList);
        imsList.add(datalist);

        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "BS_BOM");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.toString(map);
        String result = imsApi.add(mapjson, "物料清单", "BS_BOM");
//        记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "物料清单", "BS_BOM", null);
//        设置同步成功状态
        success = flag;
        return success;
    }
}
