package org.jeecg.modules.iost.ims.service.impl;

import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsWplan;
import org.jeecg.modules.iost.ims.entity.ImsBsWplanouts;
import org.jeecg.modules.iost.ims.kingdeeapi.BsWplanOutsKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.mapper.ImsBsWplanoutsMapper;
import org.jeecg.modules.iost.ims.service.IImsBsWplanoutsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * @Description: 主计划委外表
 * @Author: jeecg-boot
 * @Date:   2021-12-27
 * @Version: V1.0
 */
@Service
@Slf4j
public class ImsBsWplanoutsServiceImpl extends ServiceImpl<ImsBsWplanoutsMapper, ImsBsWplanouts> implements IImsBsWplanoutsService {
    @Autowired
    BsWplanOutsKingdeeApi kingdeeApi;

    @Autowired
    private ImsSynConstants imsSynConstants;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object dataId, Object entryId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "主计划基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());


        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsBsWplanouts> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID",dataId.toString());
        //将对应信息请求金蝶云
        try {
        	log.info("idmap:{};", idmap);
			list=kingdeeApi.select(idmap,fieldList);
        	log.info("list:{};", list);
		} catch (ParseException e) {
        	log.info("list:ParseException;");
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsBsWplanouts pojo = new ImsBsWplanouts();
            pojo.setFid(data.get("fid"));
            pojo.setSupCode(data.get("supCode"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setIsOuts("Y");
            pojo.setWplanCode(data.get("wplanCode"));
            pojo.setErpMo(data.get("erpMo"));
            pojo.setProdCode(data.get("prodCode"));
            pojo.setPqty(data.get("pqty"));
            pojo.setPbDate(data.get("pbDate"));
            pojo.setPeDate(data.get("peDate"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setBsWplanMnMtrlEx1(data.get("bsWplanMnMtrlEx1"));
            pojo.setBsWplanMnMtrlEx2(data.get("thirdRwn"));
            pojo.setCreateTime(new Date());
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            List<Map<String, Object>> bsList = new ArrayList<>();
            List<List> lists = JsonUtil.toList(data.get(data.get("erpSeq")), List.class);
            if (!CollectionUtils.isEmpty(lists)) {
                for (List o : lists) {
                    Map<String, Object> bs_wplan_mn_mtrl = new HashMap<>();
                    if (StringUtils.isNotBlank(o.get(1).toString()) && !"0.0".equals(o.get(1).toString())) {
                        bs_wplan_mn_mtrl.put("dosage", new BigDecimal(o.get(0).toString()).divide(new BigDecimal(o.get(1).toString()), 6, BigDecimal.ROUND_HALF_UP));
                    } else {
                        bs_wplan_mn_mtrl.put("dosage", 0);
                    }
                    if (StringUtils.isNotBlank(o.get(2).toString())) {
                        bs_wplan_mn_mtrl.put("nn_qty", new BigDecimal(o.get(2).toString()));
                    } else {
                        bs_wplan_mn_mtrl.put("nn_qty", 0);
                    }
                    if (StringUtils.isNotBlank(o.get(3).toString())) {
                        bs_wplan_mn_mtrl.put("tn_qty", new BigDecimal(o.get(3).toString()));
                    } else {
                        bs_wplan_mn_mtrl.put("tn_qty", 0);
                    }
                    bs_wplan_mn_mtrl.put("bs_wplan_mn_mtrl_ex1", String.valueOf(o.get(4)));
                    bs_wplan_mn_mtrl.put("third_rwn", String.valueOf(o.get(5)));
                    bs_wplan_mn_mtrl.put("mtrl_code", String.valueOf(o.get(7)));
                    bs_wplan_mn_mtrl.put("point_str", String.valueOf(o.get(8)));
                    if (StringUtils.isNotBlank(String.valueOf(o.get(6)))) {
                        bs_wplan_mn_mtrl.put("is_main", "N");
                        bs_wplan_mn_mtrl.put("main_code", String.valueOf(o.get(9)));
                    } else {
                        bs_wplan_mn_mtrl.put("is_main", "Y");
                        bs_wplan_mn_mtrl.put("main_code", String.valueOf(o.get(7)));
                    }
                    if (StringUtils.isNotBlank(bs_wplan_mn_mtrl.get("mtrl_code").toString()) && !"null".equals(bs_wplan_mn_mtrl.get("mtrl_code").toString())) {
                        bsList.add(bs_wplan_mn_mtrl);
                    }
                }
            } else {
                Map<String, Object> bs_wplan_mn_mtrl = new HashMap<>(10);
                bs_wplan_mn_mtrl.put("dosage", new BigDecimal(0));
                bs_wplan_mn_mtrl.put("nn_qty", new BigDecimal(0));
                bs_wplan_mn_mtrl.put("tn_qty", new BigDecimal(0));
                bs_wplan_mn_mtrl.put("bs_wplan_mn_mtrl_ex1", "");
                bs_wplan_mn_mtrl.put("third_rwn", "");
                bs_wplan_mn_mtrl.put("mtrl_code", "");
                bs_wplan_mn_mtrl.put("is_main", "");
                bs_wplan_mn_mtrl.put("main_code", "");
                bsList.add(bs_wplan_mn_mtrl);
            }
            Map<String, Object> datalist = new HashMap<>(12);
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, null, data, fieldList);

            datalist.put("org_id", data.get("orgId"));
            datalist.put("wplan_code", data.get("wplanCode"));
            datalist.put("erp_mo", data.get("erpMo"));
            datalist.put("prod_code", data.get("prodCode"));
            datalist.put("pt_code", data.get("ptCode"));
            datalist.put("p_qty", data.get("pqty"));
            datalist.put("pb_date", data.get("pbDate"));
            datalist.put("pe_date", data.get("peDate"));
            datalist.put("bom_ver", data.get("bomVer"));
            if (!CollectionUtils.isEmpty(bsList)) {
                datalist.put("bs_wplan_mn_mtrl", bsList);
            }
            datalist.put("remark", "");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_WPLAN");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
    	log.info("imsApi.add.mapjson:{};", mapjson);
        String result = imsApi.add(mapjson, "委外订单","BS_WPLAN");
    	log.info("imsApi.add.result:{};", result);
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "委外订单","BS_WPLAN",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
