package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonPush;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsCommonPushKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsPushConstants;
import org.jeecg.modules.iost.ims.mapper.ImsCommonPushMapper;
import org.jeecg.modules.iost.ims.service.IImsCommonPushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ImsCommonPushServiceImpl extends ServiceImpl<ImsCommonPushMapper, ImsCommonPush> implements IImsCommonPushService {

    @Autowired
    private ImsCommonPushKingdeeApi imsCommonPushKingdeeApi;

    @Autowired
    private ImsPushConstants imsPushConstants;


    @Override
    public String setData(List<Map<String, Object>> needList, String docType) {
        //读取配置
        Map<String, String> temp = imsPushConstants.get(docType);
        if (CollectionUtils.isEmpty(temp)) {
            return "false";
        }
        String sFormId = temp.get("sFormId");
        String entryIdName = temp.get("entryIdName");
        String fathersFormId = temp.get("fathersFormId");
        String fatherEntryIdName = temp.get("fatherEntryIdName");
        String pushRule = temp.get("pushRule");
        String linkFsIdName = temp.get("linkFsIdName");
        String kingDeeLogName = StringUtils.isNotBlank(temp.get("kingDeeLogName")) ? temp.get("kingDeeLogName") : "自定义下推金蝶日志";
        String kingDeeLogOztName = StringUtils.isNotBlank(temp.get("kingDeeLogOztName")) ? temp.get("kingDeeLogOztName") : "自定义下推欧智通日志";
        String kingDeeLogPushName = StringUtils.isNotBlank(temp.get("kingDeeLogPushName")) ? temp.get("kingDeeLogPushName") : "自定义下推上传日志";
        String detail = temp.get("detail");

        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOztName);
        ThreadLocalConfig.set(map2);

        //记录IMS日志
        new ImsLogUtil().ImsRequestLog(JSON.toJSONString(needList), kingDeeLogName, kingDeeLogOztName, docType);

        boolean flag = StringUtils.isNotBlank(fathersFormId) && StringUtils.isNotBlank(pushRule);
        if (flag) {
            //查询父EntryId
            List<String> fatherEntryIdList = imsCommonPushKingdeeApi.queryFatherEntryIdList(needList, fatherEntryIdName, fathersFormId, kingDeeLogName);
            List<Map<String, Object>> collect = needList.stream().filter(m -> m.containsKey("notExitFBillNo")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                List<String> tempNoList = collect.stream().map(m -> "单据编码为: " + m.get("PO_CODE") + " 且行号为: " + m.get("PO_SEQ") + " 的数据不存在").collect(Collectors.toList());
                throw new kingdeeException("操作失败!", tempNoList, docType);
            }

            //下推
            String push = imsCommonPushKingdeeApi.push(kingDeeLogPushName, fathersFormId, fatherEntryIdList, pushRule, sFormId);
            if (ImsUtil.isError(push)) {
                List<Map<String, Object>> result = ImsUtil.getSuccessEntity(push);
                if (!CollectionUtils.isEmpty(result)) {
                    List<String> fidList = result.stream().map(m -> m.get("Id").toString()).distinct().collect(Collectors.toList());
                    imsCommonPushKingdeeApi.delete(fidList, kingDeeLogName, sFormId);
                }
                throw new kingdeeException("操作失败!下推失败!", ImsUtil.getMessage(push), docType);
            }

            //查询子单据源单行内码
            Map<String, List<List<Object>>> tempMap = new HashMap<>();
            List<Map<String, Object>> pushSuccessEntityList = ImsUtil.getSuccessEntity(push);
            for (Map<String, Object> map : pushSuccessEntityList) {
                tempMap.put(map.get("Id").toString(), imsCommonPushKingdeeApi.selectLinkFsId(map.get("Id").toString(), sFormId, linkFsIdName, kingDeeLogName));
            }

            //查询子单据行内码
            for (Map<String, Object> needMap : needList) {
                String fid = "";
                String linkFsId = needMap.get(needMap.get("PO_CODE").toString() + "_" + needMap.get("PO_SEQ").toString()).toString();
                for (Map.Entry<String, List<List<Object>>> entry : tempMap.entrySet()) {
                    for (List<Object> objectList : entry.getValue()) {
                        if (objectList.get(0).toString().equals(linkFsId)) {
                            fid = entry.getKey();
                            break;
                        }
                    }
                }

                String entryId = imsCommonPushKingdeeApi.getEntryId(sFormId, fid, entryIdName, linkFsId, linkFsIdName, kingDeeLogName);
                needMap.put("FID", fid);
                needMap.put("FEntry_ID", entryId);
            }
        }

        if (!flag) {
            if (StringUtils.isBlank(detail)) {
                throw new kingdeeException("操作失败!", "直接保存的字段映射不能为空!", docType);
            }
        }

        List<Object> objectList = JsonUtil.toList(detail, Object.class);
        List<Map<String, String>> fieldList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());
        //保存
        String addTwo = imsCommonPushKingdeeApi.addTwo(needList, sFormId, kingDeeLogName, fieldList, entryIdName.split("_")[0], flag);
        if (ImsUtil.isError(addTwo)) {
            throw new kingdeeException("操作失败!修改失败!", ImsUtil.getMessage(addTwo), docType);
        }

        List<Map<String, Object>> addSuccessEntityList = ImsUtil.getSuccessEntity(addTwo);
        List<String> numberList = addSuccessEntityList.stream().map(m -> m.get("Number").toString()).collect(Collectors.toList());
        return String.join(", ", numberList);
    }


}