package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCompany;
import org.jeecg.modules.iost.ims.kingdeeapi.CompanyKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.mapper.ImsCompanyMapper;
import org.jeecg.modules.iost.ims.service.IImsCompanyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 部门基础信息
 * @Author: jeecg-boot
 * @Date: 2021-12-06
 * @Version: V1.0
 */
@Service
public class ImsCompanyServiceImpl extends ServiceImpl<ImsCompanyMapper, ImsCompany> implements IImsCompanyService {

    @Autowired
    CompanyKingdeeApi kingdeeApi;

    @Autowired
    IMSApi imsApi;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "部门基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsCompany> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FDEPTID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsCompany pojo = new ImsCompany();
            pojo.setFid(data.get("fid"));
            pojo.setCompanyCode(data.get("companyCode"));
            pojo.setCompanyCname(data.get("companyCname"));
            pojo.setParentCompanyCode(data.get("parentCompanyCode"));
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);

            //封装成IMS格式
            Map<String, Object> datalist = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, null, data, fieldList);

            datalist.put("company_code", data.get("companyCode"));
            datalist.put("company_cname", data.get("companyCname"));
            datalist.put("parent_company_code", data.get("parentCompanyCode"));
            datalist.put("remark", "");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "IMS_COMPANY");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "部门信息", "IMS_COMPANY");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "部门信息", "IMS_COMPANY", null);
        //设置同步成功状态
        success = flag;
        return success;
    }

}
