package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.DeductionFormKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsDeductionFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ImsDeductionFormServiceImpl implements IImsDeductionFormService {

    @Autowired
    private DeductionFormKingdeeApi deductionFormKingdeeApi;


    @Override
    public String setData(List<Map<String, Object>> list, String docType) {
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", "扣款单");
        ThreadLocalConfig.set(map2);

        new ImsLogUtil().ImsRequestLog(JSON.toJSONString(list), "扣款单", "扣款单", docType);

        String addTwo = deductionFormKingdeeApi.addTwo(list);
        if (ImsUtil.isError(addTwo)) {
            throw new kingdeeException("操作失败!修改失败!", ImsUtil.getMessage(addTwo), docType);
        }

        List<Map<String, Object>> addSuccessEntityList = ImsUtil.getSuccessEntity(addTwo);
        List<String> numberList = addSuccessEntityList.stream().map(m -> m.get("Number").toString()).collect(Collectors.toList());
        return String.join(", ", numberList);
    }


}
