package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsNoPurchaseOrderConfirm;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsNoPurchaseOrderConfirmApi;
import org.jeecg.modules.iost.ims.mapper.ImsNoPurchaseOrderConfirmMapper;
import org.jeecg.modules.iost.ims.service.ImsNoPurchaseOrderConfirmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/**
 * @Description: ImsNoPurchaseOrderConfirm  无采购订单收料确认
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsNoPurchaseOrderConfirmServiceImpl extends ServiceImpl<ImsNoPurchaseOrderConfirmMapper, ImsNoPurchaseOrderConfirm> implements ImsNoPurchaseOrderConfirmService {
    @Autowired
    ImsNoPurchaseOrderConfirmApi ImsNoPurchaseOrderConfirmApi;
    private String imsLogName;
    private String DocType;
    private String imsLogOZTNmae;

    public ImsNoPurchaseOrderConfirmServiceImpl() {
        this.imsLogName = "其他入库单";  //ims日志-name
        this.imsLogOZTNmae = "无采购订单收料确认";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "BS0006";  //调用者传入的标识
    }

    public String setData(List<Map<String, Object>> needLists, String code) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = ImsNoPurchaseOrderConfirmApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        ThreadLocalConfig.set(map2);
        List<ImsNoPurchaseOrderConfirm> ImsNoPurchaseOrderConfirms = new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult = new ArrayList<>();
        //添加返回结果Lists
        List<String> addResultLists = new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsNoPurchaseOrderConfirm> qw = new QueryWrapper();
        qw.in("queue_id", qidList);
        StringBuilder builder = new StringBuilder();
        int length = qidList.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append("'" + qidList.get(i) + "'");
            } else {
                builder.append(",").append("'" + qidList.get(i) + "'");
            }
        }
        qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
        List<ImsNoPurchaseOrderConfirm> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult = ResultSplitOne(repeatLists);
        }
        if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
        }
        Result result = ImsNoPurchaseOrderConfirmApi.addReturnResult(needLists, code);
        if (result.getResponseStatus().getIsSuccess()) {
            for (Map<String, Object> needmap : needLists) {
                needmap.put("FBILL_NO", result.getNumber());
                needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                //Map传入参数大写字段转化为实体类字段
                Map<String, Object> map = MapUtils.mapsChange(needmap);
                ImsNoPurchaseOrderConfirm ImsNoPurchaseOrderConfirm = JSON.parseObject(JSON.toJSONString(map), ImsNoPurchaseOrderConfirm.class);//map转为实体类对象
                ImsNoPurchaseOrderConfirms.add(ImsNoPurchaseOrderConfirm);
            }
        }
        addResultLists = ResultSplitFour(result);
        if (!CollectionUtils.isEmpty(addResultLists)) {
            throw new kingdeeException("操作失败!修改失败!", addResultLists, code);
        }

        //保存实体类
        this.saveBatch(ImsNoPurchaseOrderConfirms);
        return ImsNoPurchaseOrderConfirms.get(0).getFbillNo();
    }

    public List<String> ResultSplitOne(List<ImsNoPurchaseOrderConfirm> repeatLists) {
        String result = new String();
        LinkedHashSet<String> hashset = new LinkedHashSet<>();
        for (ImsNoPurchaseOrderConfirm ImsNoPurchaseOrderConfirm : repeatLists) {
            String queue_id = String.valueOf(ImsNoPurchaseOrderConfirm.getQueueId());
            result = "QUEUE_ID为(" + queue_id + ")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList = new ArrayList<>();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult) {
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }
}
