package org.jeecg.modules.iost.ims.service.impl;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.*;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsNondefectiveFlittingApi;
import org.jeecg.modules.iost.ims.service.IImsNondefectiveFlittingService;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.entity.ImsNondefectiveFlitting;
import org.jeecg.modules.iost.ims.mapper.ImsNondefectiveFlittingMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ImsNondefectiveFlitting 良品调拨
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Service
@Slf4j
public class ImsNondefectiveFlittingServiceImpl extends ServiceImpl<ImsNondefectiveFlittingMapper, ImsNondefectiveFlitting> implements IImsNondefectiveFlittingService {
    @Autowired
    ImsNondefectiveFlittingApi ImsNondefectiveFlittingApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;
    private String wipOrde;
    private String imsLogOZTNmae;

    public ImsNondefectiveFlittingServiceImpl() {
        this.imsLogName = "直接调拨单";  //ims日志-name(excal表里面金蝶那一列名字)
        this.imsLogOZTNmae = "良品调拨";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "BS0030";  //调用者传入的标识
        this.SEQ = "SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
        this.wipOrde = "ALLOT_CODE";  //父亲单据工单编号或者行内码
    }

    public String setData(List<Map<String, Object>> needLists, String code) {

        //追加参数(上下文对象)
        String kingdeeLogOZTName = ImsNondefectiveFlittingApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        map2.put("SEQ", SEQ);
        map2.put("wipOrde", wipOrde);
        ThreadLocalConfig.set(map2);
        //业务开始
        List<ImsNondefectiveFlitting> ImsNondefectiveFlittings = new ArrayList<>();
        //查询父单据失败的lists
        List<Map<String, Object>> SelectFatherFentryIdFailLists = new ArrayList();
        //查询父单据失败的返回结果
        List<String> SelectFatherFentryIdFailResult = new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult = new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
            //打印测试信息
            try {
                System.out.println(getCurrentTime() + " " + code + "业务开始,父单据编码为:" + maps.get("ALLOT_CODE").toString() + ",唯一标识为:" + maps.get("QUEUE_ID").toString());
            } catch (Exception e) {
                System.out.println("打印测试信息失败");
                e.printStackTrace();
            }
        }
        log.info("qidList_" + String.valueOf(qidList));
        QueryWrapper<ImsNondefectiveFlitting> qw = new QueryWrapper();
        qw.in("queue_id", qidList);
        StringBuilder builder = new StringBuilder();
        int length = qidList.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append("'" + qidList.get(i) + "'");
            } else {
                builder.append(",").append("'" + qidList.get(i) + "'");
            }
        }
        qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
        List<ImsNondefectiveFlitting> repeatLists = this.getBaseMapper().selectList(qw);
        log.info("repeatLists_" + String.valueOf(repeatLists));
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult = ResultSplitOne(repeatLists);
            log.info("queue_idRepeatResult_" + String.valueOf(queue_idRepeatResult));
        }
        if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
        }
        List<String> AddResultLists = new ArrayList();
        org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult = new org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result();
        //下推失败返回结果
        List<String> pushResultLists = new ArrayList<>();
        if (!CollectionUtils.isEmpty(needLists)) {
            if (needLists.get(0).containsKey(wipOrde) && needLists.get(0).containsKey(SEQ)) {
                log.info("wss_1 " + needLists);
                boolean b = StringUtils.isNotBlank(String.valueOf(needLists.get(0).get(wipOrde))) && StringUtils.isNotBlank(String.valueOf(needLists.get(0).get(SEQ)));
                log.info("<======wss_2入口状态：" + b);
                if (b) {
                    //判断需要修改的needLists里面有没有元素，有元素说明有东西未修改过，没有说明添加进来的数据都已经修改过了
                    List<String> Father_FEntryIDs = new ArrayList<>();
                    log.info("wss_2");
                    if (!ObjectUtils.isEmpty(needLists)) {
                        Father_FEntryIDs = ImsNondefectiveFlittingApi.queryFatherFEntryIDs(needLists, SelectFatherFentryIdFailLists);
                        log.info("Father_FEntryIDs_" + String.valueOf(Father_FEntryIDs));
                        SelectFatherFentryIdFailResult = ResultSplitTwo(SelectFatherFentryIdFailLists);
                        log.info("SelectFatherFentryIdFailResult_" + String.valueOf(SelectFatherFentryIdFailResult));
                    }
                    if (!CollectionUtils.isEmpty(SelectFatherFentryIdFailResult)) {
                        throw new kingdeeException("操作失败!", SelectFatherFentryIdFailResult, code);
                    }

                    //下推前查询当前单据的所有下推单据
                    try {
                        ImsNondefectiveFlittingApi.selectAllPush(needLists);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    //下推
                    org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result result = null;
                    try {
                        //打印测试信息
                        System.out.println(getCurrentTime() + " " + code + "下推开始，下推数据为:" + needLists);
                        result = ImsNondefectiveFlittingApi.push(needLists, Father_FEntryIDs);
                        log.info("result_" + String.valueOf(result));
                        pushResultLists = ResultSplitThree(result);
                        log.info("pushResultLists_" + String.valueOf(pushResultLists));
                    } catch (Exception e) {
                        //如果下推错误，打印异常信息
                        System.out.println(getCurrentTime() + " " + code + "下推异常,父数据为" + needLists + "错误信息为:");
                        e.printStackTrace();
                    }

                    if (!CollectionUtils.isEmpty(pushResultLists)) {
                        //打印测试信息
                        System.out.println(getCurrentTime() + " " + code + "下推失败" + pushResultLists);
                        throw new kingdeeException("操作失败!下推失败!", pushResultLists, code);
                    }
                    //打印下推成功数据
                    System.out.println(getCurrentTime() + " " + code + "下推成功，父单据数据为" + needLists + "下推子单据数据为" + result.getResponseStatus().getSuccessEntitys());
                    //查询子单据行内码maps.get("AUDIT_ID").toString()+maps.get("AUDIT_SEQ").toString()
                    for (Map<String, Object> needmap : needLists) {
                        String Son_FEntry_ID = ImsNondefectiveFlittingApi.querySonFEntryID(needmap.get(needmap.get(wipOrde).toString() + needmap.get(SEQ).toString()).toString(), needmap.get(SEQ).toString(), result.getResponseStatus().getSuccessEntitys().get(0).getId());
                        needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                        needmap.put("FEntry_ID", Son_FEntry_ID);

                    }
                }
                log.info("wss_1结束");
            }
        }
        //修改成功下推后needPushLists的数据
        log.info("<======修改成功下推后needPushLists的数据");
        AddResult = ImsNondefectiveFlittingApi.addTwo(needLists, code);
        log.info("<======AddResult:" + AddResult);
        if (AddResult.getResponseStatus().getIsSuccess()) {
            for (Map<String, Object> needmap : needLists) {
                needmap.put("FBILL_NO", AddResult.getNumber());
                //Map传入参数大写字段转化为实体类字段
                Map<String, Object> map = MapUtils.mapsChange(needmap);
                ImsNondefectiveFlitting ImsNondefectiveFlitting = JSON.parseObject(JSON.toJSONString(map), ImsNondefectiveFlitting.class);//map转为实体类对象
                ImsNondefectiveFlittings.add(ImsNondefectiveFlitting);
            }
        }
        AddResultLists = ResultSplitFour(AddResult);
        log.info("<======AddResult:" + AddResult);
        if (!CollectionUtils.isEmpty(AddResultLists)) {
            throw new kingdeeException("操作失败!修改失败!", AddResultLists, code);
        }
        //保存实体类
        log.info("<======保存实体类:" + ImsNondefectiveFlittings);
        try {
            this.saveBatch(ImsNondefectiveFlittings);
            log.info("<======保存实体类结束");
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(getCurrentTime() + " " + code + "保存数据库异常");
        }
        String fbillNo = ImsNondefectiveFlittings.get(0).getFbillNo();
        log.info("<========code 30 返回： " + fbillNo);
        return fbillNo;
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitThree(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result pushResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = pushResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = pushResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitTwo(List<Map<String, Object>> SelectFatherFentryIdFailLists) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        List<String> rustListAfter = new ArrayList<>();
        for (Map<String, Object> queue_idRepeatResultMap : SelectFatherFentryIdFailLists) {
            if (!ObjectUtils.isEmpty(queue_idRepeatResultMap.get("notExitFbillNo")) && Boolean.valueOf(queue_idRepeatResultMap.get("notExitFbillNo").toString()) == true) {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "单据" + queue_idRepeatResultMap.get(wipOrde) + "不存在，无法进行下推修改!";
                rustList.add(result);
            } else {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "唯一序号为(" + queue_id + ")且行号为(" + queue_idRepeatResultMap.get(SEQ) + ")的数据不存在，无法进行下推修改!";
                rustList.add(result);
            }
        }
        HashSet<String> set = new LinkedHashSet();
        for (String s : rustList) {
            set.add(s);
        }
        for (String s : set) {
            rustListAfter.add(s);
        }
        return rustListAfter;
    }

    public List<String> ResultSplitOne(List<ImsNondefectiveFlitting> repeatLists) {
        String result = new String();
        LinkedHashSet<String> hashset = new LinkedHashSet<>();
        for (ImsNondefectiveFlitting ImsNondefectiveFlitting : repeatLists) {
            String queue_id = String.valueOf(ImsNondefectiveFlitting.getQueueId());
            result = "QUEUE_ID为(" + queue_id + ")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList = new ArrayList<>();
        String result2 = new String();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

    public String getCurrentTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return dateFormat.format(date);
    }
}
