package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.druid.util.StringUtils;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsPayableKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsPayableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ImsPayableServiceImpl implements IImsPayableService {

    @Autowired
    private ImsPayableKingdeeApi imsPayableKingdeeApi;


    @Override
    public Map<String, Object> updateData(Map<String, Object> map) {
        Map<String, Object> result = new HashMap<>(1);

        if (!map.containsKey("SOURCE_BILL_NO_LIST")) {
            result.put("false", "修改参数不能为空");
            return result;
        }
        List<String> billNoList = JsonUtil.toList(JsonUtil.toString(map.get("SOURCE_BILL_NO_LIST")), String.class);
        if (CollectionUtils.isEmpty(billNoList)) {
            result.put("false", "SOURCE_BILL_NO_LIST不为数组");
            return result;
        }
        List<List<Object>> tempList = imsPayableKingdeeApi.getEntryIdList(billNoList.stream().map(m -> "'" + m + "'").collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(tempList)) {
            result.put("false", "没有查出数据");
            return result;
        }
        List<String> entryIdList = tempList.stream().map(m -> String.valueOf(m.get(0))).collect(Collectors.toList());
        String temp = imsPayableKingdeeApi.updateStatus(entryIdList);
        if (!StringUtils.isNumber(temp)) {
            result.put("false", temp);
            new KingdeeLogUtil().synLog("费用应付单修改", temp);
        }
        result.put("true", temp);
        return result;
    }

    @Override
    public void updateDataBySource(Map<String, Object> map) {
        List<String> entryList = JsonUtil.toList(JsonUtil.toString(map.get("ENTRY_ID_LIST")), String.class);

        List<List<Object>> tempList = imsPayableKingdeeApi.getEntryIdListBySource(entryList);

        List<String> entryIdList = tempList.stream().map(m -> String.valueOf(m.get(0))).collect(Collectors.toList());

        imsPayableKingdeeApi.updateSourceStatus(entryIdList);
    }

}
