package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsProduceCancel;
import org.jeecg.modules.iost.ims.kingdeeapi.ProduceCancelKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsProduceCancelMapper;
import org.jeecg.modules.iost.ims.service.IImsProduceCancelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description: 备料取消
 * @Author: jeecg-boot
 * @Date: 2021-12-28
 * @Version: V1.0
 */
@Service
public class ImsProduceCancelServiceImpl extends ServiceImpl<ImsProduceCancelMapper, ImsProduceCancel> implements IImsProduceCancelService {
    @Autowired
    ProduceCancelKingdeeApi produceCancelKingdeeApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;
    private String wipOrde;
    private String imsLogOZTNmae;

    public ImsProduceCancelServiceImpl() {
        this.imsLogName = "生产退料单";  //ims日志-name(excal表里面金蝶那一列名字)
        this.imsLogOZTNmae = "备料取消";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "WMS0014";  //调用者传入的标识
        this.SEQ = "ERP_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
        this.wipOrde = "ERP_SIC";  //父亲单据工单编号或者行内码
    }

    /**
     * 添加数据到金蝶云
     *
     * @param list
     * @return
     */
    @Override
    public String setData(List<Map<String, Object>> list, String code) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = produceCancelKingdeeApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        map2.put("SEQ", SEQ);
        map2.put("wipOrde", wipOrde);
        ThreadLocalConfig.set(map2);

        String FBillNo = "";
        String message = "";
        String s1 = "";
        List<String> ids = new ArrayList<>();
        List<String> Numbers = new ArrayList<>(); //父单据单据编码
        List<ImsProduceCancel> pojoList = new ArrayList<>();
        String selectmessage = "";
        //添加IMS请求日志
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(list), imsLogName, imsLogOZTNmae, DocType);
        String errors = null;
        //遍历传入的集合信息
        for (Map<String, Object> maps : list) {
            ids.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsProduceCancel> qw = new QueryWrapper();
        qw.in("queue_id", ids);
        StringBuilder builder = new StringBuilder();
        int length = ids.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append("'" + ids.get(i) + "'");
            } else {
                builder.append(",").append("'" + ids.get(i) + "'");
            }
        }
        qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
        List<ImsProduceCancel> repeatLists = this.getBaseMapper().selectList(qw);
        //筛选出重复的单据
        if (!repeatLists.isEmpty()) {
            for (String s : ids) {
                s1 = s + ",";
            }
            s1 = s1.substring(0, s1.length() - 1);
            message = message + "唯一序号为:" + s1 + "的数据已经提交过!    ";
            throw new KingdeeRepeatException("操作失败", message, code);
        }
        //筛选出有父单据行内码的数据
        if (!list.isEmpty()) {
            for (Map<String, Object> maps : list) {
                //根据父单据编码在金蝶云中查出父单据的行内码
                Object select = produceCancelKingdeeApi.select(maps);
                if (select == null) {
                    selectmessage = selectmessage + maps.get("ERP_SIC") + ",";
                } else if (select.toString().contains("Errors")) {
                    //如果有错误信息则返回
                    Map<String, Object> o = (Map<String, Object>) select;
                    String mapjson = JsonUtil.Mapjson(o);
                    Map parse = (Map) JSON.parse(mapjson);
                    Object result = parse.get("Result");
                    Map parse1 = (Map) JSON.parse(result.toString());
                    Object responseStatus = parse1.get("ResponseStatus");
                    Map parse2 = (Map) JSON.parse(responseStatus.toString());
                    Object error = parse2.get("Errors");
                    List parse3 = (List) JSON.parse(error.toString());
                    Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                    Object messages = parse4.get("Message");
                    selectmessage = messages.toString();
                } else {
                    //添加所有单据编码
                    Numbers.add(maps.get("ERP_SIC").toString());
                }
            }
            //判断是否有父单据错误
            if (selectmessage != "") {
                selectmessage = selectmessage.substring(0, selectmessage.length() - 1);
                message = "注意:单据行内码为:" + selectmessage + "不存在!   ";
                throw new KingdeeRepeatException("操作失败", message, code);
            }

            //添加单据的部分字段必须先下推才能修改
            //首先下推父单据到子单据，然后获取返回结果里面子单据的FID
            String pushmessage = null;
            List<Map<String, String>> pushResult = produceCancelKingdeeApi.pushMore(Numbers);
            //判断是否有message这个键值对，没有说明下推成功，存在说明下推失败
            if (!StringUtils.isEmpty(pushResult.get(0).get("messgae"))) {
                pushmessage = pushResult.get(0).get("messgae");
                message = "下推失败！失败原因有:" + pushmessage;
                throw new KingdeeRepeatException("操作失败", message, code);
            }
            for (Map<String, Object> needmaps : list) {
                //返回 pushmessage为空表示下推成功，如果下推失败就不向金蝶云修改信息，也不记录金蝶云日志
                for (Map<String, String> stringStringMap : pushResult) {
                    //根据父单据的行内码作为子单据的源单分录内码和主键来查询明细主键
                    List<Object> list1 = produceCancelKingdeeApi.select(needmaps.get("ERP_SIC").toString(), stringStringMap.get("FID"));
                    //修改单据带入的过滤条件
                    needmaps.put("FID", stringStringMap.get("FID"));
                    needmaps.put("FBILLNO", stringStringMap.get("FBILLNO"));
                    needmaps.put("FEntry_ID", list1.get(1));  //取名有讲究，下面转换成实体字段时候要按照取名标准来FEntry_ID转换成实体类fentryId
                    needmaps.put("FSEQ", list1.get(0));
                }
            }
            //向金蝶云修改下推后增加的数据
            JSONObject jsonObject = produceCancelKingdeeApi.addTwo(list, code);
            List<JSONObject> successEntitys = (List<JSONObject>) jsonObject.get("SuccessEntitys");
            Boolean isSuccess = (Boolean) jsonObject.get("IsSuccess");
            //根据判断
            if (isSuccess == false) {
                List<JSONObject> Errors = (List<JSONObject>) jsonObject.get("Errors");
                int i = 0;
                //拼接错误信息
                for (JSONObject error : Errors) {
                    JSONObject messags = Errors.get(i);
                    errors = errors + "---" + String.valueOf(messags.get("Message"));
                    i++;
                }
                //如果有错误删除整个单据
                produceCancelKingdeeApi.delete(list.get(0).get("FID").toString());
            } else {
                for (JSONObject successEntity : successEntitys) {
                    FBillNo = successEntity.get("Number").toString();
                }
                //修改后再次保存 (覆盖)fbillno的实体
                for (Map<String, Object> needmaps : list) {
                    needmaps.put("FBILLNO", FBillNo);
                    //Map传入参数大写字段转化为实体类字段
                    Map<String, Object> map = MapUtils.mapsChange(needmaps);
                    ImsProduceCancel produceCancel = JSON.parseObject(JSON.toJSONString(map), ImsProduceCancel.class);//map转为实体类对象
                    pojoList.add(produceCancel);
                }
                this.saveBatch(pojoList);
            }
        }
        if (errors == null) {
            return FBillNo;
        } else {
            message = "修改失败,错误原因是:" + errors;
//            System.out.println(message+"----------------------------------------");
            throw new KingdeeRepeatException("操作失败", message, code);
        }
    }
}
