package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.druid.util.StringUtils;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.PurchaseReturnKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsPurchaseReturnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class ImsPurchaseReturnServiceImpl implements IImsPurchaseReturnService {

    @Autowired
    private PurchaseReturnKingdeeApi purchaseReturnKingdeeApi;


    @Override
    public Map<String, Object> getData(Map<String, Object> map) {
        Map<String, Object> result = new HashMap<>(1);

        String kingDeeLogOZTName = "采购退料查询";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);

        //记录IMS日志
        new ImsLogUtil().ImsRequestLog(JsonUtil.toString(map), "采购退料", "采购退料查询", "PUR_MRB");

        Map<String, String> whereMap = new HashMap<>(4);
        if (map.containsKey("RETURN_MATERIAL_NO")) {
            whereMap.put("FBillNo", map.get("RETURN_MATERIAL_NO").toString());
        }
        if (map.containsKey("SUPPLIER_CODE")) {
            whereMap.put("FSupplierId.Fnumber", map.get("SUPPLIER_CODE").toString());
        }
        if (map.containsKey("RETURN_MATERIAL_DATE_FROM")) {
            whereMap.put("FDate_From", map.get("RETURN_MATERIAL_DATE_FROM").toString());
        }
        if (map.containsKey("RETURN_MATERIAL_DATE_TO")) {
            whereMap.put("FDate_To", map.get("RETURN_MATERIAL_DATE_TO").toString());
        }
        if (map.containsKey("MATERIAL_CODE")) {
            whereMap.put("FMaterialId.Fumber", map.get("MATERIAL_CODE").toString());
        }

        if (CollectionUtils.isEmpty(whereMap)) {
            result.put("false", "查询参数不能全为空");
            return result;
        }
        whereMap.put("F_LQKJ_IsReconciliation", "0");
        whereMap.put("FMRTYPE", "B");
        List<Map<String, Object>> list = purchaseReturnKingdeeApi.selectAndLog(whereMap, "采购退料查询");


        if (!CollectionUtils.isEmpty(list)) {
            if (list.get(0).containsKey("false")) {
                result.put("false", list.get(0).get("false"));
            } else {
                result.put("true", list);
            }
        } else {
            result.put("true", list);
        }
        return result;
    }

    @Override
    public Map<String, Object> updateData(Map<String, Object> map) {
        Map<String, Object> result = new HashMap<>(1);

        if (!map.containsKey("ENTRY_ID_LIST")) {
            result.put("false", "修改参数不能为空");
            return result;
        }
        List<String> entryIdList = JsonUtil.toList(JsonUtil.toString(map.get("ENTRY_ID_LIST")), String.class);
        if (CollectionUtils.isEmpty(entryIdList)) {
            result.put("false", "ENTRY_ID_LIST不为数组");
            return result;
        }
        String temp = purchaseReturnKingdeeApi.updateStatus(entryIdList);
        if (!StringUtils.isNumber(temp)) {
            result.put("false", temp);
            new KingdeeLogUtil().synLog("采购退料单修改", temp);
        }
        result.put("true", temp);
        return result;
    }


}
