package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsSmPo;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.kingdeeapi.SmPoKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsSmPoMapper;
import org.jeecg.modules.iost.ims.service.IImsSmPoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 采购订单信息
 * @Author: jeecg-boot
 * @Date: 2021-12-24
 * @Version: V1.0
 */
@Service
public class ImsSmPoServiceImpl extends ServiceImpl<ImsSmPoMapper, ImsSmPo> implements IImsSmPoService {

    @Autowired
    SmPoKingdeeApi kingdeeApi;

    @Autowired
    IMSApi imsApi;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "采购订单信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsSmPo> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        Map<String, Object> datalist = new HashMap<>();
        List<Map<String, Object>> bsList = new ArrayList<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsSmPo pojo = new ImsSmPo();
            pojo.setFid(data.get("fid"));
            pojo.setPoCode(data.get("poCode"));
            SimpleDateFormat sdf = null;
            Date indate = null;
            try {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                indate = sdf.parse(data.get("indate"));
                pojo.setIndate(indate);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            pojo.setSupCode(data.get("supCode"));
            pojo.setCompanyCode(data.get("companyCode"));
            pojo.setSeq(data.get("seq"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setMqty(data.get("mqty"));
            pojo.setRoQty(data.get("roQty"));
            pojo.setIsOuts(data.get("isOuts"));
            pojo.setRemark(data.get("remark"));
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);

            //封装成IMS格式
            Map<String, Object> sm_po_dt = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, sm_po_dt, data, fieldList);

            sm_po_dt.put("seq", data.get("seq"));
            sm_po_dt.put("mtrl_code", data.get("mtrlCode"));
            sm_po_dt.put("po_qty", data.get("poQty"));
            sm_po_dt.put("ro_qty", data.get("roQty"));
            sm_po_dt.put("is_outs", data.get("isOuts"));
            sm_po_dt.put("po_mtrl_descs", data.get("poMtrlDescs"));
            sm_po_dt.put("po_unit", data.get("poUnit"));
            sm_po_dt.put("po_unitprice", data.get("poUnitprice"));
            sm_po_dt.put("tmextax", data.get("tmextax"));
            sm_po_dt.put("tax", data.get("tax"));
            sm_po_dt.put("totalmoney", data.get("totalmoney"));
            sm_po_dt.put("tax_rate", data.get("taxRate"));
            sm_po_dt.put("tax_unitprice", data.get("taxUnitprice"));
            sm_po_dt.put("m_qty", data.get("mQty"));
            sm_po_dt.put("m_unit", data.get("mUnit"));
            sm_po_dt.put("req_date", data.get("reqDate"));
            bsList.add(sm_po_dt);

            datalist.put("po_code", data.get("poCode"));
            datalist.put("indate", sdf.format(indate));
            datalist.put("sup_code", data.get("supCode"));
            datalist.put("company_code", data.get("companyCode"));
            datalist.put("invoice_type", data.get("invoiceType"));
            datalist.put("pay_con", data.get("payCon"));
            datalist.put("pay_way", data.get("payWay"));
            datalist.put("currency", data.get("currency"));
            datalist.put("cur_rate", data.get("curRate"));
            datalist.put("factory_contact", data.get("factoryContact"));
            datalist.put("sup_phone", "null".equals(data.get("supPhone")) ? "" : data.get("supPhone"));
            datalist.put("sup_fax", "null".equals(data.get("supFax")) ? "" : data.get("supFax"));
            datalist.put("lister", data.get("lister"));
            datalist.put("reviewer", data.get("reviewer"));
            datalist.put("tax_sw", data.get("taxSw"));
            datalist.put("remark", data.get("remark"));
        }
        datalist.put("sm_po_dt", bsList);
        imsList.add(datalist);

        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "SM_PO");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "采购订单信息", "SM_PO");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "采购订单信息", "SM_PO", null);
        //设置同步成功状态
        success = flag;
        return success;
    }

}
