package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsWmsAudit;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.kingdeeapi.WmsAuditKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWmsAuditMapper;
import org.jeecg.modules.iost.ims.service.IImsWmsAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Description: 发货通知单
 * @Author: jeecg-boot
 * @Date: 2021-12-23
 * @Version: V1.0
 */
@Service
public class ImsWmsAuditServiceImpl extends ServiceImpl<ImsWmsAuditMapper, ImsWmsAudit> implements IImsWmsAuditService {

    @Autowired
    WmsAuditKingdeeApi kingdeeApi;

    @Autowired
    IMSApi imsApi;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "发货通知单";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsWmsAudit> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        Map<String, Object> datalist = new HashMap<>();
        List<Map<String, Object>> bsList = new ArrayList<>();
        List<Map<String, String>> bsStoreList = new ArrayList<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsWmsAudit pojo = new ImsWmsAudit();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setAuditCode(data.get("auditCode"));
            pojo.setAuditSeq(data.get("auditSeq"));
            pojo.setCustCode(data.get("custCode"));
            pojo.setShipDate(data.get("shipDate"));
            pojo.setShipType(data.get("shipType"));
            pojo.setShipCode(data.get("shipCode"));
            pojo.setStoreCode(data.get("storeCode"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setMqty(data.get("mqty"));
            pojo.setSaleCode(data.get("saleCode"));
            pojo.setSaleSeq(data.get("saleSeq"));
            pojo.setCreateTime(new Date());
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String, Object> wms_allot_mtrl = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, wms_allot_mtrl, data, fieldList);

            wms_allot_mtrl.put("mtrl_code", data.get("mtrlCode"));
            wms_allot_mtrl.put("tn_qty", data.get("mqty"));
            wms_allot_mtrl.put("so_id", data.get("saleCode"));
            wms_allot_mtrl.put("third_rwn", data.get("auditSeq"));
            bsList.add(wms_allot_mtrl);

            Map<String, String> bs_mn_store = new HashMap<>();
            bs_mn_store.put("store_code", data.get("storeCode"));
            bsStoreList.add(bs_mn_store);

            datalist.put("org_id", data.get("orgId"));
            datalist.put("pmn_code", data.get("auditCode"));
            datalist.put("pmn_type", 11);
            datalist.put("cust_code", data.get("custCode"));
        }
        datalist.put("bs_mn_mtrl", bsList);
        datalist.put("bs_mn_store", bsStoreList);
        imsList.add(datalist);

        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "WMS_MN");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "发货通知单信息", "WMS_MN");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "发货通知单信息", "WMS_MN", null);
        //设置同步成功状态
        success = flag;
        return success;
    }
}
