package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsWmsMn;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.kingdeeapi.WmsMnKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWmsMnMapper;
import org.jeecg.modules.iost.ims.service.IImsWmsMnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: 出库单信息
 * @Author: jeecg-boot
 * @Date: 2021-12-23
 * @Version: V1.0
 */
@Service
public class ImsWmsMnServiceImpl extends ServiceImpl<ImsWmsMnMapper, ImsWmsMn> implements IImsWmsMnService {

    @Autowired
    IMSApi imsApi;

    @Autowired
    WmsMnKingdeeApi kingdeeApi;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @Override
    public Boolean synchronization(Object dataId, Object formId, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "出库单信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        //获取自定义映射字段
        List<Map<String, String>> fieldList = imsSynConstants.getFieldList(formId.toString());

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsWmsMn> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", dataId.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, fieldList);

        List<Map<String, Object>> bsMtrlList = new ArrayList<>();
        List<Map<String, String>> bsStoreList = new ArrayList<>();
        Map<String, Object> datalist = new HashMap<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsWmsMn pojo = new ImsWmsMn();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setPmnCode(data.get("pmnCode"));
            pojo.setPmnType(data.get("pmnType"));
            pojo.setProidCode(data.get("proidCode"));
            pojo.setMnTbQty(data.get("mnTbQty"));
            pojo.setMnPlanQty(data.get("mnPlanQty"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setDosage(data.get("dosage"));
            pojo.setNnQty(data.get("nnQty"));
            pojo.setTnQty(data.get("tnQty"));
            pojo.setStoreCode(data.get("storeCode"));
            pojo.setCreateTime(new Date());
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式

            Map<String, Object> bs_mn_mtrl = new HashMap<>();
            //添加自定义字段
            ImsSynConstants.purchaseTo(datalist, bs_mn_mtrl, data, fieldList);

            bs_mn_mtrl.put("mtrl_code", data.get("mtrlCode"));
            bs_mn_mtrl.put("dosage", new BigDecimal(data.get("dosage")));
            bs_mn_mtrl.put("nn_qty", new BigDecimal(data.get("nnQty")));
            bs_mn_mtrl.put("tn_qty", new BigDecimal(data.get("tnQty")));
            bs_mn_mtrl.put("third_rwn", data.get("thirdRwn"));
            bsMtrlList.add(bs_mn_mtrl);

            Map<String, String> bs_mn_store = new HashMap<>();
            bs_mn_store.put("store_code", data.get("storeCode"));
            bsStoreList.add(bs_mn_store);

            datalist.put("org_id", data.get("orgId"));
            datalist.put("pmn_code", data.get("pmnCode"));
            datalist.put("pmn_type",/*data.get("pmnType")*/2);
            datalist.put("prod_code", data.get("proidCode"));
            datalist.put("mn_tb_qty", data.get("mnTbQty"));
            datalist.put("mn_plan_qty", data.get("mnPlanQty"));
        }
        datalist.put("bs_mn_mtrl", bsMtrlList);
        datalist.put("bs_mn_store", bsStoreList);
        imsList.add(datalist);

        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "WMS_MN");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.toString(map);
        String result = imsApi.add(mapjson, "出库申请单", "WMS_MN");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "出库申请单", "WMS_MN", null);
        //设置同步成功状态
        success = flag;
        return success;
    }
}
