package org.jeecg;


import com.kingdee.bos.webapi.entity.IdentifyInfo;
import com.kingdee.bos.webapi.entity.RepoResult;
import com.kingdee.bos.webapi.sdk.K3CloudApi;
import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.util.security.SecurityTools;
import org.jeecg.common.util.security.entity.*;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;

@Slf4j
@EnableScheduling
public class SecurityToolsTest {
    @Test
    public void Test() {
        MyKeyPair mkeyPair = SecurityTools.generateKeyPair();

        JSONObject msg = new JSONObject();
        msg.put("name", "党政辉");
        msg.put("age", 50);
        JSONObject identity = new JSONObject();
        identity.put("type", "01");
        identity.put("no", "210882165896524512");
        msg.put("identity", identity);

        // 签名加密部分
        SecuritySignReq signReq = new SecuritySignReq();
        // data为要加密的报文字符串
        signReq.setData(msg.toString());
        // 为rsa私钥
        signReq.setPrikey(mkeyPair.getPriKey());
        // 调用签名方法
        SecuritySignResp sign = SecurityTools.sign(signReq);
        // 打印出来加密数据
        // signData为签名数据
        // data为aes加密数据
        // asekey为ras加密过的aeskey
        //System.out.println(new JSONObject(sign).toStringPretty());

        // 验签解密部分
        SecurityReq req = new SecurityReq();
        //对方传过来的数据一一对应
        req.setAesKey(sign.getAesKey());
        req.setData(sign.getData());
        req.setSignData(sign.getSignData());
        //我们的公钥
        req.setPubKey(mkeyPair.getPubKey());
        //验签方法调用
        SecurityResp securityResp = SecurityTools.valid(req);
        //解密报文data为解密报文
        //sucess 为验签成功失败标志 true代码验签成功，false代表失败 w
        // System.out.println(new JSONObject(securityResp).toStringPretty());
    }

    @Autowired
    CategoryDao categoryDao;

    @Test
    public void test() throws Exception {
        //生产
        /*IdentifyInfo identifyInfo = new IdentifyInfo() {};
        identifyInfo.setAppId("232955_0ddBwZuI2mG+2eVOSf0sQcUISgx+2BlG");
        identifyInfo.setAppSecret("175e9a5ed3b04f97a5c37aa01ce747d3");
        identifyInfo.setServerUrl("http://192.168.2.26/k3cloud/");
        identifyInfo.setdCID("6221b5ff539caa");
        identifyInfo.setlCID(2052);
        identifyInfo.setUserName("Administrator");*/

        //测试
        IdentifyInfo identifyInfo = new IdentifyInfo() {
        };
        identifyInfo.setAppId("232190_5d4pQbjpRvp86VypX3TD1dXJUKXc4ppo");
        identifyInfo.setAppSecret("7e4a4779a554403eb2189bf3841552e3");
        identifyInfo.setServerUrl("http://10.10.1.212/k3cloud/");
        identifyInfo.setdCID("62fa11f8d7448e");
        identifyInfo.setlCID(2052);
        identifyInfo.setUserName("Administrator");

        K3CloudApi k3CloudApi = new K3CloudApi(identifyInfo);
        RepoResult repoResult = k3CloudApi.CheckAuthInfo();
        System.out.println(repoResult.getResponseStatus().isIsSuccess());
    }

    @Test
    public void testUpdate() {
        String K3CloudURL = "http://192.168.2.26/k3cloud/";
        String dbId = "6221b5ff539caa";
        String uid = "ad";
        String pwd = "666666";
        int lang = 2052;
        K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);
        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            System.out.println(result);
            if (result) {
                String content = "UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 1";

                String[] strings = new String[]{content};
                System.out.println("content " + content);
                String list = client.execute("LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub", strings, String.class);
                System.out.println(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSelect() {
        String K3CloudURL = "http://192.168.2.26/k3cloud/";
        String dbId = "6221b5ff539caa";
        String uid = "ad";
        String pwd = "666666";
        int lang = 2052;
        K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String data = "/*dialect*/with stepCTE AS \n" +
                        "( \n" +
                        "select b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=143103) b on a.FID=b.FID \n" +
                        "inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n" +
                        "union all\n" +
                        "select c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n" +
                        "(\n" +
                        " select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n" +
                        ") c \n" +
                        "inner join stepCTE cte on cte.z=c.f\n" +
                        ") \n" +
                        "select  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\n" +
                        "zwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\n" +
                        "from stepCTE \n" +
                        "left join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\n" +
                        "inner join T_ENG_BOM bom on bom.FID=stepCTE.FID\n" +
                        "inner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\n" +
                        "left join \n" +
                        "(\n" +
                        " select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n" +
                        " left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n" +
                        " left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n" +
                        " left join (\n" +
                        " select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n" +
                        " left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n" +
                        " ) t3 on t2.FROWID=t3.FPARENTROWID\n" +
                        ") zwl on zwl.FENTRYID=stepCTE.FENTRYID";

                String list = client.execute("LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub", new Object[]{data}, String.class);
                System.out.println(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
