import {
	http,
	apiBaseUrl
} from './request' //引入上面封装好的请求方法
import store from '../store/store.js'

//微信登录获取code
export function wxLogin() {
	return new Promise((resolve, reject) => {
		wx.login({
			success: resolve,
			fail: reject
		})
	})
}

//获取用户信息
export function getUserInfo(code) {
	return http({
		url: '/api/Validation',
		method: 'POST',
		data: {
			appid: store.state.addid,
			code: code
		}
	})
}

//获取订单数据(师傅)
export function getOrderInfo(status) {
	return http({
		url: '/api/Order/SFView',
		data: {
			status: status
		}
	})
}

//获取各个订单的数量
export function getOrderCount() {
	return http({
		url: '/api/Order/SFView'
	})
}

//获取文件下载地址
export function getFileUrl(fileid) {
	return http({
		url: '/api/UploadAttachments/GetUrl',
		data: {
			fileid: fileid
		}
	})
}

//修改信息
export function editInfo(params) {
	return http({
		url: '/api/Worker/Edit',
		method: 'POST',
		data: params
	})
}

//上传附件
export function uploadpic(file) {
	return http({
		url: '/api/UploadAttachments',
		method: 'POST',
		header: {
			test: 11
		},
		data: {
			file: file
		}
	})
}

//缴纳保证金
export function payDeposit(amount) {
	return http({
		url: '/api/payment',
		method: 'POST',
		data: {
			amount: amount,
			paytype: "保证金"
		}
	})
}

//提现
export function cashOut(amount) {
	return http({
		url: '/api/CashOut/SF',
		method: 'POST',
		data: {
			amount: amount
		}
	})
}

//获取帮助链接
export function getHelpUrl() {
	return http({
		url: '/api/HelpCenter/GetSFHelpUrl'
	})
}

//获取结算费用清单
export function getCost() {
	return http({
		url: '/api/Order/GetCostSettlement'
	})
}

//获取服务类目
export function getServiceItem() {
	return http({
		url: '/api/BaseData/ServiceItem'
	})
}

//获取手机验证码
export function getCode(phone) {
	return http({
		url: '/api/VerificationCode',
		data: {
			phone: phone
		}
	})
}

//验证验证码
export function verificationCode(phone, code) {
	return http({
		url: '/api/VerificationCode',
		method: 'POST',
		data: {
			Phone: phone,
			VerificationCode: code
		}
	})
}

//注册
export function register(params) {
	return http({
		url: '/api/Worker/Register',
		method: 'POST',
		data: params
	})
}

//意见反馈 params:{FContent:"",FSScore}
export function feedback(params) {
	return http({
		url: '/api/Feedback/SF',
		method: 'POST',
		data: {
			Model: params
		}
	})
}

//获取客服二维码
export function getKFQRcode() {
	return http({
		url: '/api/BaseData/KFQRCode'
	})
}

//获取车辆信息
export function getCarList() {
	return http({
		url: '/api/BaseData/Carsinfo'
	})
}

//获取技能证书信息
export function getCertificate() {
	return http({
		url: '/api/BaseData/Certificate'
	})
}

//获取省市区
export function getAddress() {
	return http({
		url: '/api/Worker/GetAllCity'
	})
}

//上传头像
export function postAvatar(filePath) {
	let name = filePath.replace('http://tmp/', '')
	let url = apiBaseUrl
	return new Promise((resolve, reject) => {
		wx.uploadFile({
			filePath: filePath,
			name: name,
			header: {
				test: 11
			},
			url: url + '/api/UploadAttachments',
			success: resolve,
			fail: reject
		})
	})
}


//更新用户信息(token等...)
export function init() {
	let that = this
	uni.showLoading({
		title: '加载中...'
	})
	wx.login({
		success(res) {
			store.state.code = res.code
			getUserInfo(res.code).then((re) => {
				if (re.data.code == 0) {
					console.log("更新用户信息:", JSON.parse(re.data.result.result))
					store.state.login = true
					store.state.token = re.data.result.token
					store.state.userInfo = JSON.parse(re.data.result.result)
					uni.hideLoading()
				} else {
					uni.hideLoading()
					console.log("错误信息:", re)
				}
			}).catch((res) => {
				console.log("错误信息:", res)
				uni.hideLoading()
			})
		},
		fail(res) {
			uni.hideLoading()
			console.log("错误信息:", res)
		}
	})
}
