import {http,apiBaseUrl} from './request' //引入上面封装好的请求方法
import store from '../store/store.js'


/**
 * @param {String} code wx.login获取的code
 * @description 登录京台服务器获取师傅信息以及token等
 * */
export function Validation(code){
	return http({
		url:'/api/Validation',
		method:'POST',
		data:{
			appid:store.state.addid,
			code:code
		}
	})
}

//获取订单数据
/**
 * @param {String} status 状态(待报价,待预约,待服务,已超时,待验收,待结算,退款/售后)
 * @description 获取订单数据(参数很傻逼,是中文参数,不是字符串)
 * */
export function SFView(status){
	return http({
		url:'/api/Order/SFView',
		data:{
			status:status
		}
	})
}

export function GetSFOrderTypeQty(status){
	return http({
		url:'/api/Order/GetSFOrderTypeQty',
		data:{
			status:status
		}
	})
}


/**
 * @param {String} fileid 文件id值
 * @description 获取文件的地址(用于加载出来看)
 */
export function getUrl(fileid){
	return http({
		url:'/api/UploadAttachments/GetUrl',
		data:{
			fileid:fileid
		}
	})
}


/**
 * @param {Object} params 具体参数格式看postman
 * @description 修改师傅信息
 */
export function edit(params){
	return http({
		url:'/api/Worker/Edit',
		method:'POST',
		data:params
	})
}

/**
 * @description 上传附件
 * @param {String} file 文件id值
 */
export function uploadAttachments(file){
	return http({
		url:'/api/UploadAttachments',
		method:'POST',
		header:{
			test:11
		},
		data:{
			file:file
		}
	})
}

/**
 * @description 上传头像
 * @param {String} filePath 图片路径
 */
export function postAvatar(filePath){
	let name = filePath.replace('http://tmp/','')
	let url = apiBaseUrl
	return new Promise((resolve,reject) => {
	  wx.uploadFile({
	    filePath: filePath,
	    name: name,
	    header:{
	      test:11
	    },
	    url: url+'/api/UploadAttachments',
	    success:resolve,
	    fail:reject
	  })
	})
}


/**
 * @param {String} amount 保证金数量
 * @description 缴纳保证金
 */
export function payDeposit(amount){
	return http({
		url:'/api/payment',
		method:'POST',
		data:{
			amount:amount,
			paytype:"保证金"
		}
	})
}


/**
 * @param {String} amount 提现金额
 * @description 提现请求
 */
export function cashOut(amount){
	return http({
		url:'/api/CashOut/SF',
		method:'POST',
		data:{
			amount:amount
		}
	})
}

/**
 * @description 获取帮助主页地址
 */
export function getHelpUrl(){
  return http({
    url:'/api/HelpCenter/GetSFHelpUrl'
  })
}


/**
 * @description 获取结算费用清单信息
 */
export function getCost(){
	return http({
		url:'/api/Order/GetCostSettlement'
	})
}


/**
 * @description 获取服务类目
 */
export function getServiceItem(){
	return http({
		url:'/api/BaseData/ServiceItem'
	})
}

/**
 * @description 获取手机验证码
 */
export function getCode(phone){
	return http({
		url:'/api/VerificationCode',
		data:{
			phone:phone
		}
	})
}

//验证验证码
/**
 * @param {String} phone 手机号码
 * @param {String} code 验证码
 * @description 用于验证验证码
 */
export function verificationCode(phone,code){
	return http({
		url:'/api/VerificationCode',
		method:'POST',
		data:{
			Phone:phone,
			VerificationCode:code
		}
	})
}

/**
 * @description 注册
 * @param {Object} params 见postman
 */
export function register(params){
	return http({
		url:'/api/Worker/Register',
		method:'POST',
		data:params
	})
}

/**
 * @description 提交意见反馈信息
 * @param {Object} params 见postman
 */
export function feedback(params){
	return http({
	  url:'/api/Feedback/SF',
	  method:'POST',
	  data:{
	    Model:params
	  }
	})
}


/**
 * @description 获取客服二维码
 */
export function getKFQRcode(){
  return http({
    url:'/api/BaseData/KFQRCode'
  })
}

/**
 * @description 获取车辆信息
 */
export function getCarList(){
	return http({
		url:'/api/BaseData/Carsinfo'
	})
}

/**
 * @description 获取技能证书信息
 */
export function getCertificate(){
	return http({
		url:'/api/BaseData/Certificate'
	})
}


/**
 * @description 获取省市区信息
 */
export function getAddress(){
	return http({
		url:'/api/Worker/GetAllCity'
	})
}

/**
 * @description 获取订单详情
 * @param {String} FID 
 */
export function getOrderDetails(FID){
	return http({
		url:'/api/Order/SFViewDetail',
		data:{
			FID:FID
		}
	})
}

/**
 * @description 报价下单(师傅)
 * @param {Object} params 
 */
export function postOffer(params){
	return http({
		url:'/api/Order/SFQuotedPrice',
		method:'POST',
		data:params
	})
}

/**
 * @description 抢单
 * @param {Object} params
 */
export function grabOrder(params){
	return http({
		url:'/api/Order/SFReceiveOrder',
		method:'POST',
		data:params
	})
}

/**
 * @description 完工结算图片上传
 * @param {Object} params
 */
export function donePic(params){
	return http({
		url:'/api/Order/save',
		method:'POST',
		data:params
	})
}

/**
 * @description 完工上报(验证码)
 * @param {Object} params 
 */
export function doneOrder(params){
	return http({
		url:'/api/Order/CheckAccept',
		method:'POST',
		data:params
	})
}

/**
 * @description 提交预约
 * @param {Object} params 
 */
export function sendAppointment(params){
	return http({
		url:'/api/Order/save',
		method:'POST',
		data:params
	})
}
/**
 * @description 缴纳信息费
 * @param {Object} params 
 */
export function postInformationCost(params){
	return http({
		url:'/api/Order/PayInfoFee',
		method:'POST',
		data:params
	})
}


